/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public abstract class UnitProcessor
extends org.apache.batik.parser.UnitProcessor {
    public static UnitProcessor.Context createContext(BridgeContext bridgeContext, Element element) {
        return new DefaultContext(bridgeContext, element);
    }

    public static float svgHorizontalCoordinateToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToObjectBoundingBox(string, string2, (short)2, context);
    }

    public static float svgVerticalCoordinateToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToObjectBoundingBox(string, string2, (short)1, context);
    }

    public static float svgOtherCoordinateToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToObjectBoundingBox(string, string2, (short)0, context);
    }

    public static float svgHorizontalLengthToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToObjectBoundingBox(string, string2, (short)2, context);
    }

    public static float svgVerticalLengthToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToObjectBoundingBox(string, string2, (short)1, context);
    }

    public static float svgOtherLengthToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToObjectBoundingBox(string, string2, (short)0, context);
    }

    public static float svgLengthToObjectBoundingBox(String string, String string2, short s, UnitProcessor.Context context) {
        float f = UnitProcessor.svgToObjectBoundingBox(string, string2, s, context);
        if (f < 0.0f) {
            throw new BridgeException(UnitProcessor.getBridgeContext(context), context.getElement(), "length.negative", new Object[]{string2, string});
        }
        return f;
    }

    public static float svgToObjectBoundingBox(String string, String string2, short s, UnitProcessor.Context context) {
        try {
            return org.apache.batik.parser.UnitProcessor.svgToObjectBoundingBox(string, string2, s, context);
        }
        catch (ParseException parseException) {
            throw new BridgeException(UnitProcessor.getBridgeContext(context), context.getElement(), "attribute.malformed", new Object[]{string2, string, parseException});
        }
    }

    public static float svgHorizontalLengthToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToUserSpace(string, string2, (short)2, context);
    }

    public static float svgVerticalLengthToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToUserSpace(string, string2, (short)1, context);
    }

    public static float svgOtherLengthToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToUserSpace(string, string2, (short)0, context);
    }

    public static float svgHorizontalCoordinateToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToUserSpace(string, string2, (short)2, context);
    }

    public static float svgVerticalCoordinateToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToUserSpace(string, string2, (short)1, context);
    }

    public static float svgOtherCoordinateToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToUserSpace(string, string2, (short)0, context);
    }

    public static float svgLengthToUserSpace(String string, String string2, short s, UnitProcessor.Context context) {
        float f = UnitProcessor.svgToUserSpace(string, string2, s, context);
        if (f < 0.0f) {
            throw new BridgeException(UnitProcessor.getBridgeContext(context), context.getElement(), "length.negative", new Object[]{string2, string});
        }
        return f;
    }

    public static float svgToUserSpace(String string, String string2, short s, UnitProcessor.Context context) {
        try {
            return org.apache.batik.parser.UnitProcessor.svgToUserSpace(string, string2, s, context);
        }
        catch (ParseException parseException) {
            throw new BridgeException(UnitProcessor.getBridgeContext(context), context.getElement(), "attribute.malformed", new Object[]{string2, string, parseException});
        }
    }

    protected static BridgeContext getBridgeContext(UnitProcessor.Context context) {
        if (context instanceof DefaultContext) {
            return ((DefaultContext)context).ctx;
        }
        return null;
    }

    public static class DefaultContext
    implements UnitProcessor.Context {
        protected Element e;
        protected BridgeContext ctx;

        public DefaultContext(BridgeContext bridgeContext, Element element) {
            this.ctx = bridgeContext;
            this.e = element;
        }

        public Element getElement() {
            return this.e;
        }

        public float getPixelUnitToMillimeter() {
            return this.ctx.getUserAgent().getPixelUnitToMillimeter();
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getViewportWidth() {
            return this.ctx.getViewport(this.e).getWidth();
        }

        public float getViewportHeight() {
            return this.ctx.getViewport(this.e).getHeight();
        }
    }
}

