/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedNumber;

public class SVGOMAnimatedNumber
extends AbstractSVGAnimatedValue
implements SVGAnimatedNumber {
    protected float defaultValue;
    protected boolean valid;
    protected float baseVal;
    protected float animVal;
    protected boolean changing;

    public SVGOMAnimatedNumber(AbstractElement abstractElement, String string, String string2, float f) {
        super(abstractElement, string, string2);
        this.defaultValue = f;
    }

    public float getBaseVal() {
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    protected void update() {
        Attr attr = this.element.getAttributeNodeNS(this.namespaceURI, this.localName);
        this.baseVal = attr == null ? this.defaultValue : Float.parseFloat(attr.getValue());
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaseVal(float f) throws DOMException {
        try {
            this.baseVal = f;
            this.valid = true;
            this.changing = true;
            this.element.setAttributeNS(this.namespaceURI, this.localName, String.valueOf(f));
        }
        finally {
            this.changing = false;
        }
    }

    public float getAnimVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public void setAnimatedValue(float f) {
        this.hasAnimVal = true;
        this.animVal = f;
        this.fireAnimatedAttributeListeners();
    }

    public void resetAnimatedValue() {
        this.hasAnimVal = false;
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }
}

