/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.css.engine.CSSNavigableDocument;
import org.apache.batik.css.engine.CSSNavigableDocumentListener;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.GenericAttr;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericComment;
import org.apache.batik.dom.GenericDocumentFragment;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericEntityReference;
import org.apache.batik.dom.GenericProcessingInstruction;
import org.apache.batik.dom.GenericText;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.svg.AnimatedAttributeListener;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.IdContainer;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.svg.SVGStyleSheetProcessingInstruction;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGOMDocument
extends AbstractStylableDocument
implements SVGDocument,
SVGConstants,
CSSNavigableDocument,
IdContainer {
    protected static final String RESOURCES = "org.apache.batik.dom.svg.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.svg.resources.Messages", this.getClass().getClassLoader());
    protected String referrer = "";
    protected URL url;
    protected transient boolean readonly;
    protected boolean isSVG12;
    protected HashMap cssNavigableDocumentListeners = new HashMap();
    protected AnimatedAttributeListener mainAnimatedAttributeListener = new AnimAttrListener();
    protected LinkedList animatedAttributeListeners = new LinkedList();

    protected SVGOMDocument() {
    }

    public SVGOMDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        super(documentType, dOMImplementation);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.localizableSupport.setLocale(locale);
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        try {
            return super.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return this.localizableSupport.formatMessage(string, objectArray);
        }
    }

    public String getTitle() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (object = this.getDocumentElement().getFirstChild(); object != null; object = object.getNextSibling()) {
            String string = object.getNamespaceURI();
            if (string == null || !string.equals("http://www.w3.org/2000/svg") || !object.getLocalName().equals("title")) continue;
            bl = ((SVGLangSpace)object).getXMLspace().equals("preserve");
            for (object = object.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 3) continue;
                stringBuffer.append(object.getNodeValue());
            }
            break;
        }
        object = stringBuffer.toString();
        return bl ? XMLSupport.preserveXMLSpace((String)object) : XMLSupport.defaultXMLSpace((String)object);
    }

    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String string) {
        this.referrer = string;
    }

    public String getDomain() {
        return this.url == null ? null : this.url.getHost();
    }

    public SVGSVGElement getRootElement() {
        return (SVGSVGElement)this.getDocumentElement();
    }

    public String getURL() {
        return this.documentURI;
    }

    public URL getURLObject() {
        return this.url;
    }

    public void setURLObject(URL uRL) {
        this.url = uRL;
        this.documentURI = uRL == null ? null : uRL.toString();
    }

    public void setDocumentURI(String string) {
        this.documentURI = string;
        try {
            this.url = string == null ? null : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.url = null;
        }
    }

    public Element createElement(String string) throws DOMException {
        return new GenericElement(string.intern(), this);
    }

    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment(this);
    }

    public Text createTextNode(String string) {
        return new GenericText(string, this);
    }

    public Comment createComment(String string) {
        return new GenericComment(string, this);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new GenericCDATASection(string, this);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if ("xml-stylesheet".equals(string)) {
            return new SVGStyleSheetProcessingInstruction(string2, this, (StyleSheetFactory)((Object)this.getImplementation()));
        }
        return new GenericProcessingInstruction(string, string2, this);
    }

    public Attr createAttribute(String string) throws DOMException {
        return new GenericAttr(string.intern(), this);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return new GenericEntityReference(string, this);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (string == null) {
            return new GenericAttr(string2.intern(), this);
        }
        return new GenericAttrNS(string.intern(), string2.intern(), this);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)this.implementation;
        return sVGDOMImplementation.createElementNS(this, string, string2);
    }

    public boolean isSVG12() {
        return this.isSVG12;
    }

    public void setIsSVG12(boolean bl) {
        this.isSVG12 = bl;
    }

    public boolean isId(Attr attr) {
        if (attr.getNamespaceURI() != null) {
            return false;
        }
        return "id".equals(attr.getNodeName());
    }

    public void addCSSNavigableDocumentListener(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
        if (this.cssNavigableDocumentListeners.containsKey(cSSNavigableDocumentListener)) {
            return;
        }
        DOMNodeInsertedListenerWrapper dOMNodeInsertedListenerWrapper = new DOMNodeInsertedListenerWrapper(cSSNavigableDocumentListener);
        DOMNodeRemovedListenerWrapper dOMNodeRemovedListenerWrapper = new DOMNodeRemovedListenerWrapper(cSSNavigableDocumentListener);
        DOMSubtreeModifiedListenerWrapper dOMSubtreeModifiedListenerWrapper = new DOMSubtreeModifiedListenerWrapper(cSSNavigableDocumentListener);
        DOMCharacterDataModifiedListenerWrapper dOMCharacterDataModifiedListenerWrapper = new DOMCharacterDataModifiedListenerWrapper(cSSNavigableDocumentListener);
        DOMAttrModifiedListenerWrapper dOMAttrModifiedListenerWrapper = new DOMAttrModifiedListenerWrapper(cSSNavigableDocumentListener);
        this.cssNavigableDocumentListeners.put(cSSNavigableDocumentListener, new EventListener[]{dOMNodeInsertedListenerWrapper, dOMNodeRemovedListenerWrapper, dOMSubtreeModifiedListenerWrapper, dOMCharacterDataModifiedListenerWrapper, dOMAttrModifiedListenerWrapper});
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", dOMNodeInsertedListenerWrapper, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", dOMNodeRemovedListenerWrapper, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", dOMSubtreeModifiedListenerWrapper, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", dOMCharacterDataModifiedListenerWrapper, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", dOMAttrModifiedListenerWrapper, false, null);
    }

    public void removeCSSNavigableDocumentListener(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
        EventListener[] eventListenerArray = (EventListener[])this.cssNavigableDocumentListeners.get(cSSNavigableDocumentListener);
        if (eventListenerArray == null) {
            return;
        }
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", eventListenerArray[0], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", eventListenerArray[1], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", eventListenerArray[2], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", eventListenerArray[3], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", eventListenerArray[4], false);
        this.cssNavigableDocumentListeners.remove(cSSNavigableDocumentListener);
    }

    protected AnimatedAttributeListener getAnimatedAttributeListener() {
        return this.mainAnimatedAttributeListener;
    }

    protected void overrideStyleTextChanged(CSSStylableElement cSSStylableElement, String string) {
        Iterator iterator = this.cssNavigableDocumentListeners.keySet().iterator();
        while (iterator.hasNext()) {
            CSSNavigableDocumentListener cSSNavigableDocumentListener = (CSSNavigableDocumentListener)iterator.next();
            cSSNavigableDocumentListener.overrideStyleTextChanged(cSSStylableElement, string);
        }
    }

    protected void overrideStylePropertyRemoved(CSSStylableElement cSSStylableElement, String string) {
        Iterator iterator = this.cssNavigableDocumentListeners.keySet().iterator();
        while (iterator.hasNext()) {
            CSSNavigableDocumentListener cSSNavigableDocumentListener = (CSSNavigableDocumentListener)iterator.next();
            cSSNavigableDocumentListener.overrideStylePropertyRemoved(cSSStylableElement, string);
        }
    }

    protected void overrideStylePropertyChanged(CSSStylableElement cSSStylableElement, String string, String string2, String string3) {
        Iterator iterator = this.cssNavigableDocumentListeners.keySet().iterator();
        while (iterator.hasNext()) {
            CSSNavigableDocumentListener cSSNavigableDocumentListener = (CSSNavigableDocumentListener)iterator.next();
            cSSNavigableDocumentListener.overrideStylePropertyChanged(cSSStylableElement, string, string2, string3);
        }
    }

    public void addAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        if (this.animatedAttributeListeners.contains(animatedAttributeListener)) {
            return;
        }
        this.animatedAttributeListeners.add(animatedAttributeListener);
    }

    public void removeAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        this.animatedAttributeListeners.remove(animatedAttributeListener);
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        if (element instanceof SVGStylableElement && string == null) {
            return ((SVGStylableElement)element).getOverrideStyle();
        }
        return null;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    protected Node newNode() {
        return new SVGOMDocument();
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)node;
        sVGOMDocument.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        sVGOMDocument.referrer = this.referrer;
        sVGOMDocument.url = this.url;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)node;
        sVGOMDocument.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        sVGOMDocument.referrer = this.referrer;
        sVGOMDocument.url = this.url;
        return node;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
    }

    protected class AnimAttrListener
    implements AnimatedAttributeListener {
        protected AnimAttrListener() {
        }

        public void animatedAttributeChanged(Element element, AnimatedLiveAttributeValue animatedLiveAttributeValue) {
            Iterator iterator = SVGOMDocument.this.animatedAttributeListeners.iterator();
            while (iterator.hasNext()) {
                AnimatedAttributeListener animatedAttributeListener = (AnimatedAttributeListener)iterator.next();
                animatedAttributeListener.animatedAttributeChanged(element, animatedLiveAttributeValue);
            }
        }

        public void otherAnimationChanged(Element element, String string) {
            Iterator iterator = SVGOMDocument.this.animatedAttributeListeners.iterator();
            while (iterator.hasNext()) {
                AnimatedAttributeListener animatedAttributeListener = (AnimatedAttributeListener)iterator.next();
                animatedAttributeListener.otherAnimationChanged(element, string);
            }
        }
    }

    protected class DOMAttrModifiedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMAttrModifiedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent(event);
            MutationEvent mutationEvent = (MutationEvent)event;
            this.listener.attrModified((Element)((Object)event.getTarget()), (Attr)mutationEvent.getRelatedNode(), mutationEvent.getAttrChange(), mutationEvent.getPrevValue(), mutationEvent.getNewValue());
        }
    }

    protected class DOMCharacterDataModifiedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMCharacterDataModifiedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent(event);
            this.listener.subtreeModified((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMSubtreeModifiedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMSubtreeModifiedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent(event);
            this.listener.subtreeModified((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeRemovedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMNodeRemovedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent(event);
            this.listener.nodeToBeRemoved((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeInsertedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMNodeInsertedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent(event);
            this.listener.nodeInserted((Node)((Object)event.getTarget()));
        }
    }
}

