/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.SVGExternalResourcesRequiredSupport;
import org.apache.batik.dom.svg.SVGOMAElement;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.svg.SVGURIReferenceSupport;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGGradientElement;

public abstract class SVGOMGradientElement
extends SVGStylableElement
implements SVGGradientElement {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(4);
    protected static final String[] UNITS_VALUES;
    protected static final String[] SPREAD_METHOD_VALUES;

    protected SVGOMGradientElement() {
    }

    protected SVGOMGradientElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public SVGAnimatedTransformList getGradientTransform() {
        throw new UnsupportedOperationException("SVGGradientElement.getGradientTransform is not implemented");
    }

    public SVGAnimatedEnumeration getGradientUnits() {
        return this.getAnimatedEnumerationAttribute(null, "gradientUnits", UNITS_VALUES, (short)2);
    }

    public SVGAnimatedEnumeration getSpreadMethod() {
        return this.getAnimatedEnumerationAttribute(null, "spreadMethod", SPREAD_METHOD_VALUES, (short)1);
    }

    public SVGAnimatedString getHref() {
        return SVGURIReferenceSupport.getHref(this);
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return SVGExternalResourcesRequiredSupport.getExternalResourcesRequired(this);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMAElement();
    }

    public boolean isAttributeAnimatable(String string, String string2) {
        if (string == null && string2.equals("externalResourcesRequired")) {
            return true;
        }
        return super.isAttributeAnimatable(string, string2);
    }

    public int getAttributeType(String string, String string2) {
        if (string == null) {
            if (string2.equals("gradientUnits") || string2.equals("spreadMethod")) {
                return 15;
            }
            if (string2.equals("gradientTransform")) {
                return 9;
            }
            if (string2.equals("externalResourcesRequired")) {
                return 49;
            }
        }
        return super.getAttributeType(string, string2);
    }

    public void updateAttributeValue(String string, String string2, AnimatableValue animatableValue) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                this.updateBooleanAttributeValue(this.getExternalResourcesRequired(), animatableValue);
                return;
            }
            if (string2.equals("gradientUnits")) {
                this.updateEnumerationAttributeValue(this.getGradientUnits(), animatableValue);
                return;
            }
            if (string2.equals("gradientTransform")) {
                this.updateTransformListAttributeValue(this.getGradientTransform(), animatableValue);
                return;
            }
            if (string2.equals("spreadMethod")) {
                this.updateEnumerationAttributeValue(this.getSpreadMethod(), animatableValue);
                return;
            }
        }
        super.updateAttributeValue(string, string2, animatableValue);
    }

    public AnimatableValue getUnderlyingValue(String string, String string2) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                return this.getBaseValue(this.getExternalResourcesRequired());
            }
            if (string2.equals("gradientUnits")) {
                return this.getBaseValue(this.getGradientUnits());
            }
            if (string2.equals("gradientTransform")) {
                return this.getBaseValue(this.getGradientTransform());
            }
            if (string2.equals("spreadMethod")) {
                return this.getBaseValue(this.getSpreadMethod());
            }
        }
        return super.getUnderlyingValue(string, string2);
    }

    static {
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns:xlink", "http://www.w3.org/1999/xlink");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "type", "simple");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "show", "other");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "actuate", "onLoad");
        UNITS_VALUES = new String[]{"", "userSpaceOnUse", "objectBoundingBox"};
        SPREAD_METHOD_VALUES = new String[]{"", "pad", "reflect", "repeat"};
    }
}

