/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableAngleOrIdentValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.SVGExternalResourcesRequiredSupport;
import org.apache.batik.dom.svg.SVGOMAnimatedMarkerOrientValue;
import org.apache.batik.dom.svg.SVGPreserveAspectRatioSupport;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.util.XMLSupport;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGAnimatedAngle;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGMarkerElement;

public class SVGOMMarkerElement
extends SVGStylableElement
implements SVGMarkerElement {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(1);
    protected static final String[] UNITS_VALUES;
    protected static final String[] ORIENT_TYPE_VALUES;

    protected SVGOMMarkerElement() {
    }

    public SVGOMMarkerElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public String getLocalName() {
        return "marker";
    }

    public SVGAnimatedLength getRefX() {
        return this.getAnimatedLengthAttribute(null, "refX", "0", (short)2, false);
    }

    public SVGAnimatedLength getRefY() {
        return this.getAnimatedLengthAttribute(null, "refY", "0", (short)1, false);
    }

    public SVGAnimatedEnumeration getMarkerUnits() {
        return this.getAnimatedEnumerationAttribute(null, "markerUnits", UNITS_VALUES, (short)2);
    }

    public SVGAnimatedLength getMarkerWidth() {
        return this.getAnimatedLengthAttribute(null, "markerWidth", "3", (short)2, true);
    }

    public SVGAnimatedLength getMarkerHeight() {
        return this.getAnimatedLengthAttribute(null, "markerHeight", "3", (short)1, true);
    }

    public SVGAnimatedEnumeration getOrientType() {
        SVGOMAnimatedMarkerOrientValue sVGOMAnimatedMarkerOrientValue = (SVGOMAnimatedMarkerOrientValue)this.getLiveAttributeValue(null, "orient");
        if (sVGOMAnimatedMarkerOrientValue == null) {
            sVGOMAnimatedMarkerOrientValue = new SVGOMAnimatedMarkerOrientValue(this, null, "orient");
            this.putLiveAttributeValue(null, "orient", sVGOMAnimatedMarkerOrientValue);
        }
        return sVGOMAnimatedMarkerOrientValue.getAnimatedEnumeration();
    }

    public SVGAnimatedAngle getOrientAngle() {
        SVGOMAnimatedMarkerOrientValue sVGOMAnimatedMarkerOrientValue = (SVGOMAnimatedMarkerOrientValue)this.getLiveAttributeValue(null, "orient");
        if (sVGOMAnimatedMarkerOrientValue == null) {
            sVGOMAnimatedMarkerOrientValue = new SVGOMAnimatedMarkerOrientValue(this, null, "orient");
            this.putLiveAttributeValue(null, "orient", sVGOMAnimatedMarkerOrientValue);
        }
        return sVGOMAnimatedMarkerOrientValue.getAnimatedAngle();
    }

    public void setOrientToAuto() {
        this.setAttributeNS(null, "orient", "auto");
    }

    public void setOrientToAngle(SVGAngle sVGAngle) {
        this.setAttributeNS(null, "orient", sVGAngle.getValueAsString());
    }

    public SVGAnimatedRect getViewBox() {
        throw new UnsupportedOperationException("SVGMarkerElement.getViewBox is not implemented");
    }

    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        return SVGPreserveAspectRatioSupport.getPreserveAspectRatio(this);
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return SVGExternalResourcesRequiredSupport.getExternalResourcesRequired(this);
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang(this);
    }

    public void setXMLlang(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", string);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace(this);
    }

    public void setXMLspace(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMMarkerElement();
    }

    public boolean isAttributeAnimatable(String string, String string2) {
        if (string == null && (string2.equals("externalResourcesRequired") || string2.equals("refX") || string2.equals("refY") || string2.equals("markerUnits") || string2.equals("markerWidth") || string2.equals("markerHeight") || string2.equals("orient") || string2.equals("preserveAspectRatio"))) {
            return true;
        }
        return super.isAttributeAnimatable(string, string2);
    }

    protected short getAttributePercentageInterpretation(String string, String string2) {
        if (string == null) {
            if (string2.equals("refX") || string2.equals("markerWidth")) {
                return 1;
            }
            if (string2.equals("refY") || string2.equals("markerHeight")) {
                return 2;
            }
        }
        return super.getAttributePercentageInterpretation(string, string2);
    }

    public int getAttributeType(String string, String string2) {
        if (string == null) {
            if (string2.equals("markerHeight") || string2.equals("markerWidth") || string2.equals("refX") || string2.equals("refY")) {
                return 3;
            }
            if (string2.equals("orient")) {
                return 29;
            }
            if (string2.equals("markerUnits")) {
                return 15;
            }
            if (string2.equals("viewBox")) {
                return 13;
            }
            if (string2.equals("preserveAspectRatio")) {
                return 32;
            }
        }
        return super.getAttributeType(string, string2);
    }

    public void updateAttributeValue(String string, String string2, AnimatableValue animatableValue) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                this.updateBooleanAttributeValue(this.getExternalResourcesRequired(), animatableValue);
                return;
            }
            if (string2.equals("refX")) {
                this.updateLengthAttributeValue(this.getRefX(), animatableValue);
                return;
            }
            if (string2.equals("refY")) {
                this.updateLengthAttributeValue(this.getRefY(), animatableValue);
                return;
            }
            if (string2.equals("markerUnits")) {
                this.updateEnumerationAttributeValue(this.getMarkerUnits(), animatableValue);
                return;
            }
            if (string2.equals("markerWidth")) {
                this.updateLengthAttributeValue(this.getMarkerWidth(), animatableValue);
                return;
            }
            if (string2.equals("markerHeight")) {
                this.updateLengthAttributeValue(this.getMarkerHeight(), animatableValue);
                return;
            }
            if (string2.equals("preserveAspectRatio")) {
                this.updatePreserveAspectRatioAttributeValue(this.getPreserveAspectRatio(), animatableValue);
                return;
            }
            if (string2.equals("orient")) {
                SVGOMAnimatedMarkerOrientValue sVGOMAnimatedMarkerOrientValue = (SVGOMAnimatedMarkerOrientValue)this.getLiveAttributeValue(null, string2);
                if (animatableValue == null) {
                    sVGOMAnimatedMarkerOrientValue.resetAnimatedValue();
                } else {
                    AnimatableAngleOrIdentValue animatableAngleOrIdentValue = (AnimatableAngleOrIdentValue)animatableValue;
                    if (animatableAngleOrIdentValue.isIdent() && animatableAngleOrIdentValue.getIdent().equals("auto")) {
                        sVGOMAnimatedMarkerOrientValue.setAnimatedValueToAuto();
                    } else {
                        sVGOMAnimatedMarkerOrientValue.setAnimatedValueToAngle(animatableAngleOrIdentValue.getUnit(), animatableAngleOrIdentValue.getValue());
                    }
                }
                return;
            }
        }
        super.updateAttributeValue(string, string2, animatableValue);
    }

    public AnimatableValue getUnderlyingValue(String string, String string2) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                return this.getBaseValue(this.getExternalResourcesRequired());
            }
            if (string2.equals("refX")) {
                return this.getBaseValue(this.getRefX(), (short)1);
            }
            if (string2.equals("refY")) {
                return this.getBaseValue(this.getRefY(), (short)2);
            }
            if (string2.equals("markerUnits")) {
                return this.getBaseValue(this.getMarkerUnits());
            }
            if (string2.equals("markerWidth")) {
                return this.getBaseValue(this.getMarkerWidth(), (short)1);
            }
            if (string2.equals("markerHeight")) {
                return this.getBaseValue(this.getMarkerHeight(), (short)2);
            }
            if (string2.equals("preserveAspectRatio")) {
                return this.getBaseValue(this.getPreserveAspectRatio());
            }
            if (string2.equals("orient")) {
                SVGOMAnimatedMarkerOrientValue sVGOMAnimatedMarkerOrientValue = (SVGOMAnimatedMarkerOrientValue)this.getLiveAttributeValue(null, string2);
                if (sVGOMAnimatedMarkerOrientValue.getAnimatedEnumeration().getBaseVal() == 2) {
                    SVGAngle sVGAngle = sVGOMAnimatedMarkerOrientValue.getAnimatedAngle().getBaseVal();
                    return new AnimatableAngleOrIdentValue(this, sVGAngle.getValue(), sVGAngle.getUnitType());
                }
                return new AnimatableAngleOrIdentValue((AnimationTarget)this, "auto");
            }
        }
        return super.getUnderlyingValue(string, string2);
    }

    static {
        attributeInitializer.addAttribute(null, null, "preserveAspectRatio", "xMidYMid meet");
        UNITS_VALUES = new String[]{"", "userSpaceOnUse", "stroke-width"};
        ORIENT_TYPE_VALUES = new String[]{"", "auto", ""};
    }
}

