/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.SVGOMTextContentElement;
import org.apache.batik.dom.svg.SVGURIReferenceSupport;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGTextPathElement;

public class SVGOMTextPathElement
extends SVGOMTextContentElement
implements SVGTextPathElement {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(4);
    protected static final String[] METHOD_VALUES;
    protected static final String[] SPACING_VALUES;

    protected SVGOMTextPathElement() {
    }

    public SVGOMTextPathElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public String getLocalName() {
        return "textPath";
    }

    public SVGAnimatedLength getStartOffset() {
        return this.getAnimatedLengthAttribute(null, "startOffset", "0", (short)0, true);
    }

    public SVGAnimatedEnumeration getMethod() {
        return this.getAnimatedEnumerationAttribute(null, "method", METHOD_VALUES, (short)1);
    }

    public SVGAnimatedEnumeration getSpacing() {
        return this.getAnimatedEnumerationAttribute(null, "spacing", SPACING_VALUES, (short)2);
    }

    public SVGAnimatedString getHref() {
        return SVGURIReferenceSupport.getHref(this);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMTextPathElement();
    }

    public boolean isAttributeAnimatable(String string, String string2) {
        if (string == null && (string2.equals("startOffset") || string2.equals("method") || string2.equals("spacing"))) {
            return true;
        }
        return super.isAttributeAnimatable(string, string2);
    }

    public int getAttributeType(String string, String string2) {
        if (string == null) {
            if (string2.equals("method") || string2.equals("spacing")) {
                return 15;
            }
            if (string2.equals("startOffset")) {
                return 3;
            }
        }
        return super.getAttributeType(string, string2);
    }

    public void updateAttributeValue(String string, String string2, AnimatableValue animatableValue) {
        if (string == null) {
            if (string2.equals("startOffset")) {
                this.updateLengthAttributeValue(this.getStartOffset(), animatableValue);
                return;
            }
            if (string2.equals("method")) {
                this.updateEnumerationAttributeValue(this.getMethod(), animatableValue);
                return;
            }
            if (string2.equals("spacing")) {
                this.updateEnumerationAttributeValue(this.getSpacing(), animatableValue);
                return;
            }
        }
        super.updateAttributeValue(string, string2, animatableValue);
    }

    public AnimatableValue getUnderlyingValue(String string, String string2) {
        if (string == null) {
            if (string2.equals("startOffset")) {
                return this.getBaseValue(this.getStartOffset(), (short)3);
            }
            if (string2.equals("method")) {
                return this.getBaseValue(this.getMethod());
            }
            if (string2.equals("spacing")) {
                return this.getBaseValue(this.getSpacing());
            }
        }
        return super.getUnderlyingValue(string, string2);
    }

    static {
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns:xlink", "http://www.w3.org/1999/xlink");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "type", "simple");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "show", "other");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "actuate", "onLoad");
        METHOD_VALUES = new String[]{"", "align", "stretch"};
        SPACING_VALUES = new String[]{"", "auto", "exact"};
    }
}

