/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.ext.awt.geom.ExtendedPathIterator;
import org.apache.batik.ext.awt.geom.ExtendedShape;

public class ExtendedGeneralPath
implements ExtendedShape,
Cloneable {
    protected GeneralPath path;
    int numVals = 0;
    int numSeg = 0;
    float[] values = null;
    int[] types = null;
    float mx;
    float my;
    float cx;
    float cy;

    public ExtendedGeneralPath() {
        this.path = new GeneralPath();
    }

    public ExtendedGeneralPath(int n) {
        this.path = new GeneralPath(n);
    }

    public ExtendedGeneralPath(int n, int n2) {
        this.path = new GeneralPath(n, n2);
    }

    public ExtendedGeneralPath(Shape shape) {
        this();
        this.append(shape, false);
    }

    public synchronized void arcTo(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) {
        if (f == 0.0f || f2 == 0.0f) {
            this.lineTo(f4, f5);
            return;
        }
        this.checkMoveTo();
        double d = this.cx;
        double d2 = this.cy;
        if (d == (double)f4 && d2 == (double)f5) {
            return;
        }
        Arc2D arc2D = ExtendedGeneralPath.computeArc(d, d2, f, f2, f3, bl, bl2, f4, f5);
        if (arc2D == null) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(f3), arc2D.getCenterX(), arc2D.getCenterY());
        Shape shape = affineTransform.createTransformedShape(arc2D);
        this.path.append(shape, true);
        this.makeRoom(7);
        this.types[this.numSeg++] = 4321;
        this.values[this.numVals++] = f;
        this.values[this.numVals++] = f2;
        this.values[this.numVals++] = f3;
        this.values[this.numVals++] = bl ? 1.0f : 0.0f;
        this.values[this.numVals++] = bl2 ? 1.0f : 0.0f;
        float f6 = f4;
        this.values[this.numVals++] = f6;
        this.cx = f6;
        float f7 = f5;
        this.values[this.numVals++] = f7;
        this.cy = f7;
    }

    public static Arc2D computeArc(double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, double d6, double d7) {
        double d8;
        double d9;
        double d10 = (d - d6) / 2.0;
        double d11 = (d2 - d7) / 2.0;
        d5 = Math.toRadians(d5 % 360.0);
        double d12 = Math.cos(d5);
        double d13 = Math.sin(d5);
        double d14 = d12 * d10 + d13 * d11;
        double d15 = -d13 * d10 + d12 * d11;
        double d16 = d14 * d14;
        double d17 = (d3 = Math.abs(d3)) * d3;
        double d18 = d16 / d17 + (d9 = d15 * d15) / (d8 = (d4 = Math.abs(d4)) * d4);
        if (d18 > 1.0) {
            d3 = Math.sqrt(d18) * d3;
            d4 = Math.sqrt(d18) * d4;
            d17 = d3 * d3;
            d8 = d4 * d4;
        }
        double d19 = bl == bl2 ? -1.0 : 1.0;
        double d20 = (d17 * d8 - d17 * d9 - d8 * d16) / (d17 * d9 + d8 * d16);
        d20 = d20 < 0.0 ? 0.0 : d20;
        double d21 = d19 * Math.sqrt(d20);
        double d22 = d21 * (d3 * d15 / d4);
        double d23 = d21 * -(d4 * d14 / d3);
        double d24 = (d + d6) / 2.0;
        double d25 = (d2 + d7) / 2.0;
        double d26 = d24 + (d12 * d22 - d13 * d23);
        double d27 = d25 + (d13 * d22 + d12 * d23);
        double d28 = (d14 - d22) / d3;
        double d29 = (d15 - d23) / d4;
        double d30 = (-d14 - d22) / d3;
        double d31 = (-d15 - d23) / d4;
        double d32 = Math.sqrt(d28 * d28 + d29 * d29);
        double d33 = d28;
        d19 = d29 < 0.0 ? -1.0 : 1.0;
        double d34 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        d32 = Math.sqrt((d28 * d28 + d29 * d29) * (d30 * d30 + d31 * d31));
        d33 = d28 * d30 + d29 * d31;
        d19 = d28 * d31 - d29 * d30 < 0.0 ? -1.0 : 1.0;
        double d35 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        if (!bl2 && d35 > 0.0) {
            d35 -= 360.0;
        } else if (bl2 && d35 < 0.0) {
            d35 += 360.0;
        }
        d35 %= 360.0;
        d34 %= 360.0;
        Arc2D.Double double_ = new Arc2D.Double();
        double_.x = d26 - d3;
        double_.y = d27 - d4;
        double_.width = d3 * 2.0;
        double_.height = d4 * 2.0;
        double_.start = -d34;
        double_.extent = -d35;
        return double_;
    }

    public synchronized void moveTo(float f, float f2) {
        this.makeRoom(2);
        this.types[this.numSeg++] = 0;
        float f3 = f;
        this.values[this.numVals++] = f3;
        this.mx = f3;
        this.cx = f3;
        float f4 = f2;
        this.values[this.numVals++] = f4;
        this.my = f4;
        this.cy = f4;
    }

    public synchronized void lineTo(float f, float f2) {
        this.checkMoveTo();
        this.path.lineTo(f, f2);
        this.makeRoom(2);
        this.types[this.numSeg++] = 1;
        float f3 = f;
        this.values[this.numVals++] = f3;
        this.cx = f3;
        float f4 = f2;
        this.values[this.numVals++] = f4;
        this.cy = f4;
    }

    public synchronized void quadTo(float f, float f2, float f3, float f4) {
        this.checkMoveTo();
        this.path.quadTo(f, f2, f3, f4);
        this.makeRoom(4);
        this.types[this.numSeg++] = 2;
        this.values[this.numVals++] = f;
        this.values[this.numVals++] = f2;
        float f5 = f3;
        this.values[this.numVals++] = f5;
        this.cx = f5;
        float f6 = f4;
        this.values[this.numVals++] = f6;
        this.cy = f6;
    }

    public synchronized void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.checkMoveTo();
        this.path.curveTo(f, f2, f3, f4, f5, f6);
        this.makeRoom(6);
        this.types[this.numSeg++] = 3;
        this.values[this.numVals++] = f;
        this.values[this.numVals++] = f2;
        this.values[this.numVals++] = f3;
        this.values[this.numVals++] = f4;
        float f7 = f5;
        this.values[this.numVals++] = f7;
        this.cx = f7;
        float f8 = f6;
        this.values[this.numVals++] = f8;
        this.cy = f8;
    }

    public synchronized void closePath() {
        if (this.numSeg != 0 && this.types[this.numSeg - 1] == 4) {
            return;
        }
        if (this.numSeg != 0 && this.types[this.numSeg - 1] != 0) {
            this.path.closePath();
        }
        this.makeRoom(0);
        this.types[this.numSeg++] = 4;
        this.cx = this.mx;
        this.cy = this.my;
    }

    protected void checkMoveTo() {
        if (this.numSeg == 0) {
            return;
        }
        switch (this.types[this.numSeg - 1]) {
            case 0: {
                this.path.moveTo(this.values[this.numVals - 2], this.values[this.numVals - 1]);
                break;
            }
            case 4: {
                if (this.numSeg == 1) {
                    return;
                }
                if (this.types[this.numSeg - 2] != 0) break;
                this.path.moveTo(this.values[this.numVals - 2], this.values[this.numVals - 1]);
                break;
            }
        }
    }

    public void append(Shape shape, boolean bl) {
        this.append(shape.getPathIterator(new AffineTransform()), bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n = pathIterator.currentSegment(dArray);
            pathIterator.next();
            if (bl && this.numVals != 0) {
                if (n == 0) {
                    double d = dArray[0];
                    double d2 = dArray[1];
                    if (d != (double)this.cx || d2 != (double)this.cy) {
                        n = 1;
                    } else {
                        if (pathIterator.isDone()) break;
                        n = pathIterator.currentSegment(dArray);
                        pathIterator.next();
                    }
                }
                bl = false;
            }
            switch (n) {
                case 4: {
                    this.closePath();
                    break;
                }
                case 0: {
                    this.moveTo((float)dArray[0], (float)dArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo((float)dArray[0], (float)dArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3], (float)dArray[4], (float)dArray[5]);
                }
            }
        }
    }

    public void append(ExtendedPathIterator extendedPathIterator, boolean bl) {
        while (!extendedPathIterator.isDone()) {
            float[] fArray = new float[7];
            int n = extendedPathIterator.currentSegment(fArray);
            extendedPathIterator.next();
            if (bl && this.numVals != 0) {
                if (n == 0) {
                    float f = fArray[0];
                    float f2 = fArray[1];
                    if (f != this.cx || f2 != this.cy) {
                        n = 1;
                    } else {
                        if (extendedPathIterator.isDone()) break;
                        n = extendedPathIterator.currentSegment(fArray);
                        extendedPathIterator.next();
                    }
                }
                bl = false;
            }
            switch (n) {
                case 4: {
                    this.closePath();
                    break;
                }
                case 0: {
                    this.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4321: {
                    this.arcTo(fArray[0], fArray[1], fArray[2], fArray[3] != 0.0f, fArray[4] != 0.0f, fArray[5], fArray[6]);
                }
            }
        }
    }

    public synchronized int getWindingRule() {
        return this.path.getWindingRule();
    }

    public void setWindingRule(int n) {
        this.path.setWindingRule(n);
    }

    public synchronized Point2D getCurrentPoint() {
        if (this.numVals == 0) {
            return null;
        }
        return new Point2D.Double(this.cx, this.cy);
    }

    public synchronized void reset() {
        this.path.reset();
        this.numSeg = 0;
        this.numVals = 0;
    }

    public void transform(AffineTransform affineTransform) {
        if (affineTransform.getType() != 0) {
            throw new IllegalArgumentException("ExtendedGeneralPaths can not be transformed");
        }
    }

    public synchronized Shape createTransformedShape(AffineTransform affineTransform) {
        return this.path.createTransformedShape(affineTransform);
    }

    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    public synchronized Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public boolean contains(double d, double d2) {
        return this.path.contains(d, d2);
    }

    public boolean contains(Point2D point2D) {
        return this.path.contains(point2D);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.path.contains(d, d2, d3, d4);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.path.contains(rectangle2D);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.path.intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.path.intersects(rectangle2D);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.path.getPathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.path.getPathIterator(affineTransform, d);
    }

    public ExtendedPathIterator getExtendedPathIterator() {
        return new EPI();
    }

    public Object clone() {
        try {
            ExtendedGeneralPath extendedGeneralPath = (ExtendedGeneralPath)super.clone();
            extendedGeneralPath.path = (GeneralPath)this.path.clone();
            extendedGeneralPath.values = new float[this.values.length];
            System.arraycopy(this.values, 0, extendedGeneralPath.values, 0, this.values.length);
            extendedGeneralPath.numVals = this.numVals;
            extendedGeneralPath.types = new int[this.types.length];
            System.arraycopy(this.types, 0, extendedGeneralPath.types, 0, this.types.length);
            extendedGeneralPath.numSeg = this.numSeg;
            return extendedGeneralPath;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void makeRoom(int n) {
        if (this.values == null) {
            this.values = new float[2 * n];
            this.types = new int[2];
            this.numVals = 0;
            this.numSeg = 0;
            return;
        }
        if (this.numVals + n > this.values.length) {
            int n2 = this.values.length * 2;
            if (n2 < this.numVals + n) {
                n2 = this.numVals + n;
            }
            float[] fArray = new float[n2];
            System.arraycopy(this.values, 0, fArray, 0, this.numVals);
            this.values = fArray;
        }
        if (this.numSeg == this.types.length) {
            int[] nArray = new int[this.types.length * 2];
            System.arraycopy(this.types, 0, nArray, 0, this.types.length);
            this.types = nArray;
        }
    }

    class EPI
    implements ExtendedPathIterator {
        int segNum = 0;
        int valsIdx = 0;

        EPI() {
        }

        public int currentSegment() {
            return ExtendedGeneralPath.this.types[this.segNum];
        }

        public int currentSegment(double[] dArray) {
            int n = ExtendedGeneralPath.this.types[this.segNum];
            switch (n) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    break;
                }
                case 2: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    break;
                }
                case 3: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    dArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    dArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    break;
                }
                case 4321: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    dArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    dArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    dArray[6] = ExtendedGeneralPath.this.values[this.valsIdx + 6];
                }
            }
            return n;
        }

        public int currentSegment(float[] fArray) {
            int n = ExtendedGeneralPath.this.types[this.segNum];
            switch (n) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    fArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    fArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    break;
                }
                case 2: {
                    fArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    fArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    fArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    fArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    break;
                }
                case 3: {
                    fArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    fArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    fArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    fArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    fArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    fArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    break;
                }
                case 4321: {
                    fArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    fArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    fArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    fArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    fArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    fArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    fArray[6] = ExtendedGeneralPath.this.values[this.valsIdx + 6];
                }
            }
            return n;
        }

        public int getWindingRule() {
            return ExtendedGeneralPath.this.path.getWindingRule();
        }

        public boolean isDone() {
            return this.segNum == ExtendedGeneralPath.this.numSeg;
        }

        public void next() {
            int n = ExtendedGeneralPath.this.types[this.segNum++];
            switch (n) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    this.valsIdx += 2;
                    break;
                }
                case 2: {
                    this.valsIdx += 4;
                    break;
                }
                case 3: {
                    this.valsIdx += 6;
                    break;
                }
                case 4321: {
                    this.valsIdx += 7;
                }
            }
        }
    }
}

