/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.xml.XMLCharacters;

public class XMLUtilities
extends XMLCharacters {
    protected XMLUtilities() {
    }

    public static boolean isXMLSpace(char c) {
        return c <= ' ' && (4294977024L >> c & 1L) != 0L;
    }

    public static boolean isXMLNameFirstCharacter(char c) {
        return (NAME_FIRST_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXML11NameFirstCharacter(char c) {
        return (NAME11_FIRST_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXMLNameCharacter(char c) {
        return (NAME_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXML11NameCharacter(char c) {
        return (NAME11_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXMLCharacter(int n) {
        return n >= 65536 && n <= 0x10FFFF || (XML_CHARACTER[n / 32] & 1 << n % 32) != 0;
    }

    public static boolean isXML11Character(int n) {
        return n >= 1 && n <= 55295 || n >= 57344 && n <= 65533 || n >= 65536 && n <= 0x10FFFF;
    }

    public static boolean isXMLPublicIdCharacter(char c) {
        return c < '\u0080' && (PUBLIC_ID_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXMLVersionCharacter(char c) {
        return c < '\u0080' && (VERSION_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXMLAlphabeticCharacter(char c) {
        return c < '\u0080' && (ALPHABETIC_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static Reader createXMLDocumentReader(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 128);
        byte[] byArray = new byte[4];
        int n = pushbackInputStream.read(byArray);
        if (n > 0) {
            pushbackInputStream.unread(byArray, 0, n);
        }
        if (n == 4) {
            switch (byArray[0] & 0xFF) {
                case 0: {
                    if (byArray[1] != 60 || byArray[2] != 0 || byArray[3] != 63) break;
                    return new InputStreamReader((InputStream)pushbackInputStream, "UnicodeBig");
                }
                case 60: {
                    switch (byArray[1] & 0xFF) {
                        case 0: {
                            if (byArray[2] != 63 || byArray[3] != 0) break;
                            return new InputStreamReader((InputStream)pushbackInputStream, "UnicodeLittle");
                        }
                        case 63: {
                            if (byArray[2] != 120 || byArray[3] != 109) break;
                            Reader reader = XMLUtilities.createXMLDeclarationReader(pushbackInputStream, "UTF8");
                            String string = XMLUtilities.getXMLDeclarationEncoding(reader, "UTF8");
                            return new InputStreamReader((InputStream)pushbackInputStream, string);
                        }
                    }
                    break;
                }
                case 76: {
                    if (byArray[1] != 111 || (byArray[2] & 0xFF) != 167 || (byArray[3] & 0xFF) != 148) break;
                    Reader reader = XMLUtilities.createXMLDeclarationReader(pushbackInputStream, "CP037");
                    String string = XMLUtilities.getXMLDeclarationEncoding(reader, "CP037");
                    return new InputStreamReader((InputStream)pushbackInputStream, string);
                }
                case 254: {
                    if ((byArray[1] & 0xFF) != 255) break;
                    return new InputStreamReader((InputStream)pushbackInputStream, "Unicode");
                }
                case 255: {
                    if ((byArray[1] & 0xFF) != 254) break;
                    return new InputStreamReader((InputStream)pushbackInputStream, "Unicode");
                }
            }
        }
        return new InputStreamReader((InputStream)pushbackInputStream, "UTF8");
    }

    protected static Reader createXMLDeclarationReader(PushbackInputStream pushbackInputStream, String string) throws IOException {
        byte[] byArray = new byte[128];
        int n = pushbackInputStream.read(byArray);
        if (n > 0) {
            pushbackInputStream.unread(byArray, 0, n);
        }
        return new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 4, n), string);
    }

    protected static String getXMLDeclarationEncoding(Reader reader, String string) throws IOException {
        int n = reader.read();
        if (n != 108) {
            return string;
        }
        n = reader.read();
        if (!XMLUtilities.isXMLSpace((char)n)) {
            return string;
        }
        while (XMLUtilities.isXMLSpace((char)(n = reader.read()))) {
        }
        if (n != 118) {
            return string;
        }
        n = reader.read();
        if (n != 101) {
            return string;
        }
        n = reader.read();
        if (n != 114) {
            return string;
        }
        n = reader.read();
        if (n != 115) {
            return string;
        }
        n = reader.read();
        if (n != 105) {
            return string;
        }
        n = reader.read();
        if (n != 111) {
            return string;
        }
        n = reader.read();
        if (n != 110) {
            return string;
        }
        n = reader.read();
        while (XMLUtilities.isXMLSpace((char)n)) {
            n = reader.read();
        }
        if (n != 61) {
            return string;
        }
        while (XMLUtilities.isXMLSpace((char)(n = reader.read()))) {
        }
        if (n != 34 && n != 39) {
            return string;
        }
        char c = (char)n;
        while ((n = reader.read()) != c) {
            if (XMLUtilities.isXMLVersionCharacter((char)n)) continue;
            return string;
        }
        n = reader.read();
        if (!XMLUtilities.isXMLSpace((char)n)) {
            return string;
        }
        while (XMLUtilities.isXMLSpace((char)(n = reader.read()))) {
        }
        if (n != 101) {
            return string;
        }
        n = reader.read();
        if (n != 110) {
            return string;
        }
        n = reader.read();
        if (n != 99) {
            return string;
        }
        n = reader.read();
        if (n != 111) {
            return string;
        }
        n = reader.read();
        if (n != 100) {
            return string;
        }
        n = reader.read();
        if (n != 105) {
            return string;
        }
        n = reader.read();
        if (n != 110) {
            return string;
        }
        n = reader.read();
        if (n != 103) {
            return string;
        }
        n = reader.read();
        while (XMLUtilities.isXMLSpace((char)n)) {
            n = reader.read();
        }
        if (n != 61) {
            return string;
        }
        while (XMLUtilities.isXMLSpace((char)(n = reader.read()))) {
        }
        if (n != 34 && n != 39) {
            return string;
        }
        c = (char)n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != -1) {
            if (n == c) {
                return XMLUtilities.encodingToJavaEncoding(stringBuffer.toString(), string);
            }
            stringBuffer.append((char)n);
        }
        return string;
    }

    public static String encodingToJavaEncoding(String string, String string2) {
        String string3 = EncodingUtilities.javaEncoding(string);
        return string3 == null ? string2 : string3;
    }
}

