/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.conf;

import de.miethxml.toolkit.conf.ConfigListener;
import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.conf.LocaleListener;
import de.miethxml.toolkit.conf.LocaleRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class LocaleImpl
implements ConfigListener {
    private static LocaleImpl instance;
    public static String NOLABEL;
    private Properties locale;
    private String lang = "en";
    private ArrayList listeners = new ArrayList();
    private ArrayList repositories = new ArrayList();
    private Hashtable currentRepositories = new Hashtable();
    private String location = "lang";
    public static String DEFAULT_LANG;

    static {
        NOLABEL = "!!-fixme-no-label-!!";
        DEFAULT_LANG = "en";
    }

    private LocaleImpl() {
        this.locale = new Properties();
        this.init();
    }

    private void load() {
        String file = String.valueOf(this.location) + File.separator + this.lang + ".txt";
        try {
            this.locale.load(new FileInputStream(file));
        }
        catch (IOException ioe) {
            System.out.println("Error: could not load the language-file.\nFile: " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        Properties properties = this.locale;
        synchronized (properties) {
            String value = this.locale.getProperty(key);
            if (value == null) {
                Enumeration e = this.currentRepositories.elements();
                while (e.hasMoreElements()) {
                    Hashtable locales = (Hashtable)e.nextElement();
                    if (!locales.containsKey(key)) continue;
                    return (String)locales.get(key);
                }
                return NOLABEL;
            }
            return value;
        }
    }

    public static synchronized LocaleImpl getInstance() {
        if (instance == null) {
            instance = new LocaleImpl();
            ConfigManager.getInstance().addConfigListener(instance);
        }
        return instance;
    }

    public static synchronized void configureLocaleLocation(String dir) {
        instance.setLocation(dir);
    }

    private void init() {
        this.locale.clear();
        this.lang = ConfigManager.getInstance().getProperty("lang");
        if (this.lang == null || this.lang.length() == 0) {
            this.lang = DEFAULT_LANG;
        }
        Locale.setDefault(new Locale(this.lang));
        this.load();
        this.fireLangChanged();
    }

    public void configChanged(String configKey) {
        if (configKey.equals("lang")) {
            this.init();
            this.fireLangChanged();
        }
    }

    public void addLocaleListener(LocaleListener l) {
        this.listeners.add(l);
    }

    public void removeLocaleListener(LocaleListener l) {
        int i = 0;
        while (i < this.listeners.size()) {
            LocaleListener tl = (LocaleListener)this.listeners.get(i);
            if (tl.equals(l)) {
                this.listeners.remove(i);
                return;
            }
            ++i;
        }
    }

    private void fireLangChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            LocaleListener l = (LocaleListener)this.listeners.get(i);
            l.langChanged();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String key, String t) {
        Properties properties = this.locale;
        synchronized (properties) {
            this.locale.setProperty(key, t);
        }
    }

    public void addLocaleRepository(LocaleRepository rep) {
        this.repositories.add(rep);
        this.currentRepositories.put(rep, rep.getLocales(this.lang));
    }

    public void removeLocaleRepository(LocaleRepository rep) {
        this.repositories.remove(rep);
        this.currentRepositories.remove(rep);
    }

    public void setLocation(String location) {
        this.location = location;
        this.init();
        this.fireLangChanged();
    }

    public String getLanguage() {
        return this.lang;
    }
}

