/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;

public class SplashScreen
extends Window
implements Runnable {
    public static final int VMARGIN = 40;
    public static final int HMARGIN = 10;
    public static final int WIDTH = 320;
    public static final int HEIGHT = 200;
    private BufferedImage buffer;
    private Image img;
    private int height = 200;
    private int width = 320;
    private int margin = 5;
    private String imgSrc;
    private int process = 0;
    private int length;
    private int current = 0;
    private boolean paint = false;
    private Color pcolor = new Color(150, 220, 255);
    private String msg;
    private int elementLength = 10;
    private int elementHeight = 4;
    private int space;
    private int fontHeight;
    private int subSteps = 0;
    private int currentSubStep = 0;
    private boolean hasSubStebs = false;
    private int arcAngle = 0;
    private AlphaComposite ac = AlphaComposite.getInstance(10, 0.3f);

    public SplashScreen(int width, int height, String imgSrc, String msg) {
        super(new Frame());
        this.imgSrc = imgSrc;
        this.height = height;
        this.width = width;
        this.msg = msg;
        this.setSize(width + 10, height + 40);
        this.center();
        this.createBuffer();
        this.getImage();
    }

    public SplashScreen(String imgSrc, String msg) {
        this(320, 200, imgSrc, msg);
    }

    public SplashScreen(int width, int height, String imgSrc) {
        this(width, height, imgSrc, "");
    }

    private void getImage() {
        this.img = Toolkit.getDefaultToolkit().getImage(this.imgSrc);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.img, 1);
        try {
            mt.waitForID(1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Graphics2D g2 = (Graphics2D)this.buffer.getGraphics();
        g2.drawImage(this.img, this.margin, this.margin, this.width, this.height, this);
        this.repaint();
    }

    private void center() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = this.getBounds();
        this.setLocation((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
    }

    public void setMaximum(int max) {
        this.process = max;
        this.elementLength = this.width / (2 * max);
        this.space = (this.width - this.process * this.elementLength) / (this.process - 1);
        Graphics2D g = this.buffer.createGraphics();
        g.setColor(Color.gray);
        int i = 0;
        while (i < this.process) {
            g.drawRect(5 + i * (this.elementLength + this.space), this.height + 10, this.elementLength, this.elementHeight);
            ++i;
        }
    }

    public void next() {
        if (this.current < this.process) {
            this.paintNextProgress(this.current, "");
            ++this.current;
            this.repaint();
        }
    }

    public void next(String msg) {
        if (this.current < this.process) {
            this.paintNextProgress(this.current, msg);
            ++this.current;
            this.repaint();
        }
        this.toFront();
    }

    private void paintNextProgress(int next, String msg) {
        Graphics2D g2 = (Graphics2D)this.buffer.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.pcolor);
        g2.fillRect(5 + next * (this.elementLength + this.space) + 1, this.height + 11, this.elementLength - 1, this.elementHeight - 1);
        g2.setColor(Color.WHITE);
        g2.fillRect(1, this.height + 15, this.width - 8, 24);
        if (msg.length() > 0) {
            g2.setColor(Color.black);
            g2.drawString(msg, 5, this.height + 16 + this.fontHeight);
        }
        g2.dispose();
    }

    public void run() {
        this.getImage();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private void createBuffer() {
        this.buffer = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g = this.buffer.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.gray);
        g.drawRect(0, 0, this.width + 10 - 1, this.height + 40 - 1);
        g.drawRect(4, 4, this.width + 1, this.height + 1);
        this.fontHeight = g.getFontMetrics().getHeight();
        int i = 0;
        while (i < this.process) {
            g.drawRect(5 + i * (this.elementLength + this.space), this.height + 10, this.elementLength, this.elementHeight);
            ++i;
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.buffer, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this.toFront();
    }

    public void startSubSteps(int count) {
        this.subSteps = count;
        this.hasSubStebs = true;
        this.currentSubStep = 0;
        this.arcAngle = 360 / count * -1;
        this.paintNextSubStep(this.currentSubStep);
        this.repaint();
        this.toFront();
    }

    public void nextSubStep() {
        ++this.currentSubStep;
        this.paintNextSubStep(this.currentSubStep);
        this.repaint();
        this.toFront();
    }

    public void endSubSteps() {
        this.hasSubStebs = false;
        this.paintNextSubStep(this.currentSubStep);
        this.repaint();
        this.toFront();
    }

    private void paintNextSubStep(int current) {
        Graphics2D g2 = (Graphics2D)this.buffer.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasSubStebs) {
            int w;
            int y;
            int x;
            if (this.width > this.height) {
                x = 2 * this.margin + (this.width - this.height) / 2;
                y = 2 * this.margin;
                w = this.height - 2 * this.margin;
            } else {
                x = this.margin * 2;
                y = 2 * this.margin + (this.height - this.width) / 2;
                w = this.width - 2 * this.margin;
            }
            int startAngle = (current - 1) * this.arcAngle + 90;
            g2.setComposite(this.ac);
            if (this.currentSubStep == 0) {
                g2.setColor(Color.BLACK);
                g2.drawArc(x, y, w, w, 0, 360);
            } else if (this.currentSubStep == this.subSteps) {
                g2.setColor(Color.GRAY);
                g2.fillArc(x, y, w, w, startAngle, -270 - startAngle);
            } else {
                g2.setColor(Color.GRAY);
                g2.fillArc(x, y, w, w, startAngle, this.arcAngle);
            }
        } else {
            g2.drawImage(this.img, this.margin, this.margin, this.width, this.height, this);
        }
    }
}

