/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.io;

import de.miethxml.toolkit.io.AuthenticationHandler;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelException;
import de.miethxml.toolkit.io.FileModelHandler;
import de.miethxml.toolkit.plugins.PluginManager;
import de.miethxml.toolkit.plugins.PluginReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class FileModelManager
implements PluginReceiver {
    private ArrayList handlers = new ArrayList();
    private ArrayList authenticators = new ArrayList();
    static /* synthetic */ Class class$0;

    public void addFileModelHandler(FileModelHandler handler) {
        this.handlers.add(handler);
    }

    public void removeFileModelHandler(FileModelHandler handler) {
        this.handlers.remove(handler);
    }

    public FileModel createFileModel(String uri) throws FileModelException {
        Iterator i = this.handlers.iterator();
        while (i.hasNext()) {
            FileModelHandler handler = (FileModelHandler)i.next();
            if (!handler.isSupported(uri)) continue;
            if (handler.authenticationRequired(uri)) {
                return this.authenticate(handler, uri);
            }
            return handler.createFileModel(uri);
        }
        throw new FileModelException("No Handler for URI:" + uri + " found.");
    }

    public void addPlugin(Object obj) {
        FileModelHandler handler = (FileModelHandler)obj;
        this.handlers.add(0, handler);
    }

    public Collection getInterfaces() {
        HashSet<String> set = new HashSet<String>();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.miethxml.toolkit.io.FileModelHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        set.add(clazz.getName());
        return set;
    }

    public void removePlugin(Object obj) {
        this.handlers.remove(obj);
    }

    public void setPluginManager(PluginManager manager) {
        manager.addPluginReceiver(this);
    }

    public void addAuthenticationHandler(AuthenticationHandler handler) {
        this.authenticators.add(handler);
    }

    private FileModel authenticate(FileModelHandler handler, String uri) {
        Iterator i = this.authenticators.iterator();
        while (i.hasNext()) {
            AuthenticationHandler authenticator = (AuthenticationHandler)i.next();
            try {
                return authenticator.authenticate(handler, uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

