/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.locale.ui;

import de.miethxml.toolkit.gui.JGoodiesSeparator;
import de.miethxml.toolkit.locale.LocaleChangeListener;
import de.miethxml.toolkit.locale.LocaleService;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;

public class LocaleUIBuilder
implements LocaleChangeListener {
    private HashMap components = new HashMap();
    private LocaleService locale;

    public LocaleUIBuilder(LocaleService locale) {
        this.locale = locale;
        locale.addLocaleChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localeChanged(LocaleService locale) {
        this.locale.removeLocaleChangeListener(this);
        this.locale = locale;
        locale.addLocaleChangeListener(this);
        HashMap hashMap = this.components;
        synchronized (hashMap) {
            Iterator i = this.components.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                SoftReference ref = (SoftReference)this.components.get(key);
                Object obj = ref.get();
                if (obj != null) {
                    if (obj instanceof JLabel) {
                        ((JLabel)obj).setText(locale.getString(key));
                        continue;
                    }
                    if (obj instanceof JButton) {
                        ((JButton)obj).setText(locale.getString(key));
                        continue;
                    }
                    if (obj instanceof JMenuItem) {
                        ((JMenuItem)obj).setText(locale.getString(key));
                        continue;
                    }
                    if (!(obj instanceof JGoodiesSeparator)) continue;
                    ((JGoodiesSeparator)obj).setText(locale.getString(key));
                    continue;
                }
                i.remove();
            }
        }
    }

    public JLabel getLabel(String key) {
        JLabel label = new JLabel();
        this.setLabelText(key, label);
        return label;
    }

    public void setLabelText(String key, JLabel label) {
        label.setText(this.locale.getString(key));
        this.addComponent(key, label);
    }

    public JButton getButton(String key) {
        JButton button = new JButton();
        this.setButtonText(key, button);
        return button;
    }

    public void setButtonText(String key, JButton button) {
        button.setText(this.locale.getString(key));
        this.addComponent(key, button);
    }

    public void setMenuItemText(String key, JMenuItem menuitem) {
        menuitem.setText(this.locale.getString(key));
        this.addComponent(key, menuitem);
    }

    public void setMenuItemText(String key, JMenuItem menuitem, String defaultValue) {
        if (this.locale.getString(key) == null) {
            menuitem.setText(defaultValue);
        } else {
            menuitem.setText(this.locale.getString(key));
            this.addComponent(key, menuitem);
        }
    }

    public JMenuItem getMenuItem(String key) {
        JMenuItem item = new JMenuItem();
        this.setMenuItemText(key, item);
        return item;
    }

    public JMenuItem getMenuItem(String key, String defaultValue) {
        JMenuItem item = new JMenuItem();
        this.setMenuItemText(key, item, defaultValue);
        return item;
    }

    public JComponent getSeparator(String key) {
        JGoodiesSeparator separator = new JGoodiesSeparator();
        separator.setText(this.locale.getString(key));
        this.addComponent(key, separator);
        return separator;
    }

    private void addComponent(String key, Object obj) {
        this.components.put(key, new SoftReference<Object>(obj));
    }
}

