/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository;

import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelFlavor;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositoryModel;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.ui.RepositoryImportView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.TransferHandler;

public class RepositoryTransferHandler
extends TransferHandler
implements RepositorySelectionListener,
ActionListener {
    private RepositoryImportView view = new RepositoryImportView();
    private boolean droptargetTree = true;
    private FileModel selectedModel;
    private RepositoryModel model;
    public static String ACTION_IMPORT = "repository.import";
    public static String ACTION_PASTE = "repository.clipboard.paste";

    public RepositoryTransferHandler(RepositoryModel model) {
        super(null);
        this.view.initialize();
        this.model = model;
        model.addRepositorySelectionListener(this);
    }

    public boolean importData(JComponent c, Transferable t) {
        List files;
        DataFlavor flavor = this.getFileModelArrayFlavor();
        if (t.isDataFlavorSupported(flavor)) {
            try {
                FileModel[] modelArray = (FileModel[])t.getTransferData(flavor);
                Point p = c.getLocationOnScreen();
                int x = (int)p.getX() + c.getWidth() / 2;
                int y = (int)p.getY() + c.getHeight() / 2;
                this.view.setDialogLocation(x, y);
                this.view.importFileModel(modelArray, this.selectedModel, this.model);
                return true;
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((files = this.getFileList(t)).size() > 0) {
            Point p = c.getLocationOnScreen();
            int x = (int)p.getX() + c.getWidth() / 2;
            int y = (int)p.getY() + c.getHeight() / 2;
            this.view.setDialogLocation(x, y);
            this.view.importFileList(files, this.selectedModel, this.model);
            return true;
        }
        return false;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].isFlavorJavaFileListType()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < flavors.length) {
            if (flavors[i].isFlavorTextType()) {
                return true;
            }
            ++i;
        }
        DataFlavor flavor = this.getFileModelArrayFlavor();
        int i2 = 0;
        while (i2 < flavors.length) {
            if (flavors[i2].equals(flavor)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public int getSourceActions(JComponent c) {
        return 1;
    }

    protected Transferable createTransferable(JComponent c) {
        FileListTransferable trans = null;
        if (this.selectedModel != null) {
            trans = new FileListTransferable();
            File f = new File(this.selectedModel.getPath());
            if (f.exists()) {
                ArrayList<File> files = new ArrayList<File>();
                files.add(f);
                trans.setFileList(files);
            }
            trans.setFileModelArray(new FileModel[]{this.selectedModel});
        }
        return trans;
    }

    public boolean isDroptargetTree() {
        return this.droptargetTree;
    }

    public void setDroptargetTree(boolean droptargetTree) {
        this.droptargetTree = droptargetTree;
    }

    public void directorySelected(Reloadable model, FileModel directory) {
        this.selectedModel = directory;
    }

    public void fileSelected(Reloadable model, FileModel file) {
        this.selectedModel = file;
    }

    public void unselect() {
        this.selectedModel = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(ACTION_PASTE)) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    List files;
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable t = clipboard.getContents(null);
                    if (t != null && (files = RepositoryTransferHandler.this.getFileList(clipboard.getContents(null))).size() > 0) {
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        int x = (int)(dim.getWidth() / 2.0);
                        int y = (int)(dim.getHeight() / 2.0);
                        RepositoryTransferHandler.this.view.setDialogLocation(x, y);
                        RepositoryTransferHandler.this.view.importFileList(files, RepositoryTransferHandler.this.selectedModel, RepositoryTransferHandler.this.model);
                    }
                }
            });
            t.start();
        } else if (e.getActionCommand().equals(ACTION_IMPORT)) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    JFileChooser fc = new JFileChooser();
                    int choise = fc.showDialog(null, "Import");
                    if (choise == 0) {
                        ArrayList<File> files = new ArrayList<File>();
                        files.add(fc.getSelectedFile());
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        int x = (int)(dim.getWidth() / 2.0);
                        int y = (int)(dim.getHeight() / 2.0);
                        RepositoryTransferHandler.this.view.setDialogLocation(x, y);
                        RepositoryTransferHandler.this.view.importFileList(files, RepositoryTransferHandler.this.selectedModel, RepositoryTransferHandler.this.model);
                    }
                }
            });
            t.start();
        }
    }

    private List getFileList(Transferable t) {
        ArrayList<File> files;
        block17: {
            files = new ArrayList<File>();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (list.size() > 0) {
                        Iterator i = list.iterator();
                        while (i.hasNext()) {
                            File file = (File)i.next();
                            files.add(file);
                        }
                    }
                }
                catch (UnsupportedFlavorException ufe) {
                    ufe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                    String[] list = text.split("\n");
                    if (list.length <= 0) break block17;
                    int i = 0;
                    while (i < list.length) {
                        File f = new File(list[i]);
                        if (f.exists()) {
                            files.add(f);
                        } else if (list[i].startsWith("file:")) {
                            try {
                                f = new File(new URI(list[i].trim()));
                                files.add(f);
                            }
                            catch (URISyntaxException e1) {
                                e1.printStackTrace();
                            }
                        }
                        ++i;
                    }
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return files;
    }

    private DataFlavor getFileModelArrayFlavor() {
        FileModelFlavor flavor = null;
        try {
            flavor = new FileModelFlavor();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return flavor;
    }

    public class FileListTransferable
    implements Transferable {
        private DataFlavor[] flavors;
        private List files;
        private FileModel[] models;

        public FileListTransferable() {
            this.flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, RepositoryTransferHandler.this.getFileModelArrayFlavor()};
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            try {
                if (flavor.equals(new FileModelFlavor())) {
                    return this.models;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.files;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor.equals(RepositoryTransferHandler.this.getFileModelArrayFlavor())) {
                return true;
            }
            return flavor.equals(DataFlavor.javaFileListFlavor);
        }

        public void setFileList(List files) {
            this.files = files;
        }

        public void setFileModelArray(FileModel[] array) {
            this.models = array;
        }
    }
}

