/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.search;

import de.miethxml.hawron.io.FileMatcher;
import de.miethxml.toolkit.io.FileModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;

public class RepositoryIndexer {
    private static final String FIELD_FILENAME = "filename";
    private long lastIndex = 0L;
    private boolean interrupt = false;
    private FileMatcher matcher;

    public RepositoryIndexer() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("*");
        this.matcher = new FileMatcher(list);
    }

    public void index(String indexFile, String dataFile) {
        File data;
        boolean create = false;
        File index = new File(indexFile);
        if (!index.exists() && !index.isDirectory()) {
            create = true;
        }
        if (this.lastIndex == 0L) {
            create = true;
        }
        if ((data = new File(dataFile)).exists() && data.isDirectory()) {
            try {
                IndexWriter writer = new IndexWriter(index, (Analyzer)new StandardAnalyzer(), create);
                this.indexDirectory(writer, data);
                writer.optimize();
                writer.close();
                writer = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void index(String indexDir, String dataDir, long lastIndex) {
        this.lastIndex = lastIndex;
        this.interrupt = false;
        this.index(indexDir, dataDir);
    }

    private void indexDirectory(IndexWriter writer, File directory) {
        File[] entries = directory.listFiles();
        int i = 0;
        while (i < entries.length && !this.interrupt) {
            if (entries[i].isDirectory()) {
                this.indexDirectory(writer, entries[i]);
            } else {
                entries[i].isFile();
            }
            ++i;
        }
    }

    private void indexFile(IndexWriter writer, FileModel file) {
        if (this.isSupported(file.getPath()) && file.lastModified() > this.lastIndex) {
            Document doc = new Document();
            if (!file.getName().toLowerCase().endsWith(".sxw")) {
                try {
                    doc.add(Field.Text((String)"contents", (Reader)new BufferedReader(new InputStreamReader(file.getContent().getInputStream()))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                doc.add(Field.Keyword((String)FIELD_FILENAME, (String)file.getPath()));
                writer.addDocument(doc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isSupported(String path) {
        return this.matcher.matches(path);
    }

    public void interruptIndexing() {
        this.interrupt = true;
    }

    public void setFilter(List filter) {
        this.matcher.setPattern((Collection)filter);
    }

    public void cleanupIndex(String indexfile) {
        try {
            IndexReader ireader = IndexReader.open((File)new File(indexfile));
            TermEnum te = ireader.terms();
            ArrayList<Term> list = new ArrayList<Term>();
            while (te.next()) {
                File f;
                Term t = te.term();
                if (!t.field().equals(FIELD_FILENAME) || (f = new File(t.text())).exists()) continue;
                list.add(t);
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Term t = (Term)i.next();
                ireader.delete(t);
            }
            ireader.close();
            ireader = null;
            te = null;
            list.clear();
            list = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

