/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.conf.LocaleListener;
import de.miethxml.toolkit.gui.LocaleButton;
import de.miethxml.toolkit.gui.LocaleLabel;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelException;
import de.miethxml.toolkit.io.IOListener;
import de.miethxml.toolkit.io.Utilities;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositoryModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class RepositoryImportView
implements IOListener,
LocaleListener {
    private JDialog dialog;
    private List files;
    private Utilities ioUtilities = new Utilities();
    private File to;
    private JProgressBar progressBar;
    private boolean interrupt = false;
    private JLabel count;
    private JLabel step;
    private int fileCount;
    private String currentDirectory;
    private RepositoryModel model;
    private FileModel destination;
    private FileModel[] importData;

    public RepositoryImportView() {
        this.ioUtilities.addIOListener(this);
    }

    public void initialize() {
        this.dialog = new JDialog();
        this.dialog.getContentPane().setLayout(new BorderLayout());
        FormLayout layout = new FormLayout("3dlu,pref,2dlu,fill:120dlu:grow,3dlu", "3dlu,p,2dlu,p,2dlu,p,3dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        LocaleLabel label = new LocaleLabel("view.fileimport.label.import");
        builder.add((Component)label, cc.xy(2, 2));
        this.count = new JLabel("");
        builder.add((Component)this.count, cc.xy(4, 2));
        label = new LocaleLabel("view.fileimport.label.step");
        builder.add((Component)label, cc.xy(2, 4));
        this.step = new JLabel("");
        builder.add((Component)this.step, cc.xy(4, 4));
        label = new LocaleLabel("view.fileimport.label.progress");
        builder.add((Component)label, cc.xy(2, 6));
        this.progressBar = new JProgressBar();
        builder.add((Component)this.progressBar, cc.xy(4, 6));
        this.dialog.getContentPane().add((Component)builder.getPanel(), "Center");
        JButton[] buttons = new JButton[]{new LocaleButton("common.button.cancel")};
        buttons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RepositoryImportView.this.interrupt();
                RepositoryImportView.this.dialog.setVisible(false);
            }
        });
        ButtonBarBuilder bbuilder = new ButtonBarBuilder();
        bbuilder.addRelatedGap();
        bbuilder.addGlue();
        bbuilder.addGriddedButtons(buttons);
        this.dialog.getContentPane().add((Component)bbuilder.getPanel(), "South");
        this.dialog.pack();
    }

    public void importFileList(List files, FileModel destination, RepositoryModel model) {
        this.files = files;
        this.interrupt = false;
        this.destination = destination;
        this.model = model;
        this.count.setText(LocaleImpl.getInstance().getString("view.fileimport.report.prepare"));
        this.step.setText("");
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.fileCount = 0;
        this.dialog.setVisible(true);
        this.invokeThread();
    }

    public void importFileModel(FileModel[] data, FileModel dest, RepositoryModel m) {
        this.importData = data;
        this.destination = dest;
        this.model = m;
        this.count.setText(LocaleImpl.getInstance().getString("view.fileimport.report.prepare"));
        this.step.setText("");
        this.progressBar.setIndeterminate(true);
        this.fileCount = 0;
        this.dialog.setVisible(true);
        Thread t = new Thread(new Runnable(){

            public void run() {
                if (RepositoryImportView.this.destination.isFile()) {
                    try {
                        RepositoryImportView.this.destination = RepositoryImportView.this.destination.getParent();
                    }
                    catch (FileModelException e) {
                        e.printStackTrace();
                    }
                }
                int i = 0;
                while (i < RepositoryImportView.this.importData.length) {
                    try {
                        RepositoryImportView.this.ioUtilities.copy(RepositoryImportView.this.importData[i], RepositoryImportView.this.destination);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "Error", 2);
                    }
                    ++i;
                }
                RepositoryImportView.this.dialog.setVisible(false);
                RepositoryImportView.this.model.reload();
            }
        });
        t.start();
    }

    private void invokeThread() {
        Runnable r = new Runnable(){

            public void run() {
                if (RepositoryImportView.this.destination.isFile()) {
                    try {
                        RepositoryImportView.this.destination = RepositoryImportView.this.destination.getParent();
                    }
                    catch (FileModelException e) {
                        e.printStackTrace();
                    }
                }
                Iterator i = RepositoryImportView.this.files.iterator();
                while (i.hasNext() && !RepositoryImportView.this.interrupt) {
                    File from = (File)i.next();
                    try {
                        RepositoryImportView.this.ioUtilities.copy(from, RepositoryImportView.this.destination);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "Error", 2);
                    }
                    RepositoryImportView.this.dialog.setVisible(false);
                    RepositoryImportView.this.model.reload();
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public void completeWriting() {
        if (this.fileCount == 0) {
            this.progressBar.setIndeterminate(false);
        }
        ++this.fileCount;
        this.progressBar.setValue(this.fileCount);
    }

    public void copy(int files) {
        this.count.setText(String.valueOf(files) + " " + LocaleImpl.getInstance().getString("view.fileimport.report.filecount"));
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(files);
        this.progressBar.setIndeterminate(true);
    }

    public void startWriting(String name, long length) {
        this.step.setText(String.valueOf(LocaleImpl.getInstance().getString("view.fileimport.report.copy")) + " " + name);
    }

    public void wrote(long count, long total) {
    }

    public void complete() {
        this.dialog.setVisible(false);
    }

    public void interrupt() {
        this.interrupt = true;
        this.ioUtilities.interrupt();
    }

    public void langChanged() {
    }

    public void directorySelected(Reloadable model, FileModel directory) {
        this.currentDirectory = directory.getPath();
    }

    public void fileSelected(Reloadable model, FileModel file) {
        try {
            this.currentDirectory = file.getParent().getPath();
        }
        catch (FileModelException e) {
            e.printStackTrace();
        }
    }

    public void unselect() {
        this.currentDirectory = null;
    }

    public void setDialogLocation(int centerX, int centerY) {
        int x = centerX - this.dialog.getWidth() / 2;
        int y = centerY - this.dialog.getHeight() / 2;
        if (x < 0) {
            x = 2;
        }
        if (y < 0) {
            y = 2;
        }
        this.dialog.setLocation(x, y);
    }
}

