/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.editor;

import de.miethxml.toolkit.component.Configurable;
import de.miethxml.toolkit.component.GuiConfigurable;
import de.miethxml.toolkit.gui.ButtonPanel;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.locale.LocaleChangeListener;
import de.miethxml.toolkit.locale.LocaleService;
import de.miethxml.toolkit.plugins.PluginReceiver;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.ui.editor.EditorAction;
import de.miethxml.toolkit.repository.ui.editor.ExternalEditor;
import de.miethxml.toolkit.repository.ui.editor.ExternalEditorManager;
import de.miethxml.toolkit.repository.ui.editor.ExternalEditorSetup;
import de.miethxml.toolkit.repository.ui.editor.RepositoryEditor;
import de.miethxml.toolkit.setup.SetupProcessListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;

public class EditorManager
implements GuiConfigurable,
LocaleChangeListener,
PluginReceiver,
SetupProcessListener,
RepositorySelectionListener {
    private Hashtable editors = new Hashtable();
    private ArrayList brokenEditors = new ArrayList();
    private ArrayList setupEditors = new ArrayList();
    private ArrayList actions = new ArrayList();
    private ArrayList externalEditors = new ArrayList();
    private ButtonPanel buttonpanel;
    private JMenu menu;
    private Collection interfaces = new HashSet();
    private boolean initialized = false;
    private ExternalEditorManager exManager;
    private boolean checksupportedextensions = true;
    private LocaleService locale;
    private ExternalEditorSetup setup = new ExternalEditorSetup();
    static /* synthetic */ Class class$0;

    public EditorManager(LocaleService locale) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.miethxml.toolkit.repository.ui.editor.RepositoryEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.interfaces.add(clazz.getName());
        this.locale = locale;
    }

    public void initialize() {
        this.exManager = new ExternalEditorManager();
        this.exManager.initialize();
        this.setup.setExternalEditorManager(this.exManager);
        this.setup.initialize();
        this.buttonpanel = new ButtonPanel("editor.buttonpanel.menu.title");
        this.buttonpanel.init();
        this.menu = new JMenu(this.locale.getString("editor.buttonpanel.menu.title", "Editors"));
        this.locale.addLocaleChangeListener(this);
        this.initEditors();
    }

    public void dispose() {
        Enumeration e = this.editors.elements();
        while (e.hasMoreElements()) {
            EditorAction action = (EditorAction)e.nextElement();
            action.destroy();
        }
    }

    public void initEditors() {
        this.editors.clear();
        this.actions.clear();
        int x = 0;
        while (x < this.exManager.getEditorCount()) {
            ExternalEditor edit = this.exManager.getEditor(x);
            if (edit.isSupportedPlatform()) {
                this.addEditor(edit);
                this.externalEditors.add(edit);
            }
            ++x;
        }
    }

    public JPanel getButtonPanel() {
        return this.buttonpanel;
    }

    public void setup() {
        RepositoryEditor edit;
        RepositoryEditor edit2;
        Iterator i = this.setupEditors.iterator();
        while (i.hasNext()) {
            Configurable conf = (Configurable)i.next();
            if (conf.isSetup()) continue;
            edit2 = (RepositoryEditor)((Object)conf);
            this.buttonpanel.removeAction((Action)this.editors.get(edit2));
        }
        i = this.brokenEditors.iterator();
        while (i.hasNext()) {
            edit = (RepositoryEditor)i.next();
            Configurable conf = (Configurable)((Object)edit);
            conf.setup();
            if (!conf.isSetup()) continue;
            this.addEditor(edit);
            i.remove();
            this.setupEditors.add(edit);
        }
        i = this.externalEditors.iterator();
        while (i.hasNext()) {
            edit = (RepositoryEditor)i.next();
            this.buttonpanel.removeAction((Action)this.editors.get(edit));
            i.remove();
        }
        this.externalEditors.clear();
        int x = 0;
        while (x < this.exManager.getEditorCount()) {
            edit2 = this.exManager.getEditor(x);
            if (((ExternalEditor)edit2).isSupportedPlatform()) {
                this.addEditor(edit2);
                this.externalEditors.add(edit2);
            }
            ++x;
        }
    }

    public boolean isSetup() {
        return true;
    }

    public JMenu getEditorMenu() {
        return this.menu;
    }

    public void addPlugin(Object obj) {
        RepositoryEditor edit = (RepositoryEditor)obj;
        this.addEditor(edit);
    }

    public Collection getInterfaces() {
        return this.interfaces;
    }

    public void removePlugin(Object obj) {
    }

    private void addEditor(RepositoryEditor edit) {
        if (edit instanceof Configurable) {
            Configurable conf = (Configurable)((Object)edit);
            conf.setup();
            if (conf.isSetup()) {
                this.setupEditors.add(edit);
            } else {
                this.brokenEditors.add(edit);
                return;
            }
        }
        edit.init();
        EditorAction action = new EditorAction(edit);
        action.setCheckSupportedExtensions(this.checksupportedextensions);
        this.actions.add(action);
        this.editors.put(edit, action);
        this.buttonpanel.addAction(action);
        this.menu.add(action);
    }

    public void endSetup() {
        this.setup();
    }

    public void startSetup() {
    }

    public void setCheckSupportedExtensions(boolean b) {
        this.checksupportedextensions = b;
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            EditorAction action = (EditorAction)i.next();
            action.setCheckSupportedExtensions(b);
        }
    }

    public void directorySelected(Reloadable model, FileModel directory) {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            EditorAction action = (EditorAction)i.next();
            action.directorySelected(model, directory);
        }
    }

    public void fileSelected(Reloadable model, FileModel file) {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            EditorAction action = (EditorAction)i.next();
            action.fileSelected(model, file);
        }
    }

    public void unselect() {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            EditorAction action = (EditorAction)i.next();
            action.unselect();
        }
    }

    public void localeChanged(LocaleService locale) {
        this.menu.setText(locale.getString("action.buttonpanel.menu.title", "Editors"));
    }

    public String getLabel() {
        return this.setup.getLabel();
    }

    public JComponent getSetupComponent() {
        return this.setup.getSetupComponent();
    }
}

