/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.editor;

import de.miethxml.toolkit.cache.Cacheable;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.gui.LocaleButton;
import de.miethxml.toolkit.repository.ui.editor.CacheableEditor;
import de.miethxml.toolkit.repository.ui.editor.EditorCloseListener;
import de.miethxml.toolkit.repository.ui.editor.RepositoryEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class PlainTextEditor
implements Cacheable,
CacheableEditor {
    private JFrame frame;
    private String file;
    private JTextArea editor;
    private ArrayList listeners;
    private boolean closing = false;
    boolean isNew;
    boolean changed = false;
    private String[] unsupported = new String[]{".gif", ".jpeg", ".jpg", ".png", ".doc"};
    private String[] xmlextension = new String[]{".xml", ".svg", ".xslt", ".xsl", ".xmap", ".xconf", ".fo", ".xsp"};
    private boolean destroy = false;

    public PlainTextEditor() {
        this.listeners = new ArrayList();
    }

    public void init() {
        this.frame = new JFrame();
        this.frame.setTitle("PlainTextEditor");
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.getToolbar(), "North");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (!PlainTextEditor.this.destroy && !PlainTextEditor.this.closing) {
                    PlainTextEditor.this.setVisible(false);
                }
            }
        });
        this.editor = new JTextArea();
        this.editor.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                PlainTextEditor.this.changed = true;
            }

            public void keyTyped(KeyEvent e) {
                PlainTextEditor.this.changed = true;
            }

            public void keyReleased(KeyEvent e) {
                PlainTextEditor.this.changed = true;
            }
        });
        JScrollPane sp = new JScrollPane(this.editor);
        this.frame.getContentPane().add((Component)sp, "Center");
        this.frame.setSize(new Dimension(640, 480));
    }

    public void open(String file) {
        this.file = file;
        this.changed = false;
        this.editor.setText("");
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                this.editor.append(String.valueOf(line) + "\n");
            }
            in.close();
            in = null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.frame.validate();
        this.frame.setTitle(file);
        this.isNew = false;
        this.frame.setSize(new Dimension(640, 480));
    }

    public void save() {
        if (this.isNew) {
            JFileChooser fc = new JFileChooser(this.file);
            int returnVal = fc.showSaveDialog(this.frame);
            if (returnVal == 0) {
                this.file = fc.getSelectedFile().getAbsolutePath();
                this.frame.setTitle(this.file);
            } else {
                this.file = null;
            }
        }
        if (this.file != null) {
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));
                out.write(this.editor.getText());
                out.flush();
                out.close();
                this.changed = false;
                out = null;
                this.isNew = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void destroy() {
        this.destroy = true;
        this.editor = null;
    }

    public Icon getIcon() {
        ImageIcon icon = new ImageIcon("icons/text_edit.gif");
        return icon;
    }

    public JComponent getSetup() {
        return null;
    }

    public String getToolTip(String lang) {
        return "PlainTextEditor";
    }

    public boolean hasSetup() {
        return false;
    }

    public boolean isSetup() {
        return true;
    }

    public boolean isSupported(String extension) {
        int i = 0;
        while (i < this.unsupported.length) {
            if (extension.endsWith(this.unsupported[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void newFile(String file) {
        this.isNew = true;
        this.changed = false;
        this.file = file;
        this.frame.setTitle("New File");
        this.editor.setText("");
        this.frame.setSize(new Dimension(640, 480));
    }

    private boolean isXMLDocument(String file) {
        int i = 0;
        while (i < this.xmlextension.length) {
            if (file.toLowerCase().endsWith(this.xmlextension[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private JToolBar getToolbar() {
        JToolBar toolbar = new JToolBar();
        LocaleButton button = new LocaleButton("comon.button.save", new ImageIcon("icons/save.gif"), false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlainTextEditor.this.save();
            }
        });
        toolbar.add(button);
        button = new LocaleButton("common.button.copy", new ImageIcon("icons/copy_edit.gif"), false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlainTextEditor.this.editor.copy();
            }
        });
        toolbar.add(button);
        button = new LocaleButton("common.button.paste", new ImageIcon("icons/paste_edit.gif"), false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlainTextEditor.this.editor.paste();
            }
        });
        toolbar.add(button);
        button = new LocaleButton("common.button.cut", new ImageIcon("icons/cut_edit.gif"), false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlainTextEditor.this.editor.cut();
            }
        });
        toolbar.add(button);
        return toolbar;
    }

    private boolean checkChanges() {
        if (this.changed) {
            int option = JOptionPane.showConfirmDialog(null, LocaleImpl.getInstance().getString("editor.plaintexteditord.dialog.savechanges"));
            if (option == 0) {
                this.save();
                return true;
            }
            if (option == 2) {
                return false;
            }
            this.changed = false;
        }
        return true;
    }

    public void setVisible(boolean state) {
        this.closing = !state;
        if (!state && this.checkChanges()) {
            this.frame.setVisible(state);
            if (!this.destroy) {
                this.fireCloseEvent();
            }
        } else {
            this.frame.setVisible(state);
        }
    }

    public void addEditorCloseListener(EditorCloseListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEditorCloseListener(EditorCloseListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCloseEvent() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                EditorCloseListener l = (EditorCloseListener)i.next();
                l.close(this);
            }
        }
    }

    public RepositoryEditor createNewEditor() {
        PlainTextEditor edit = new PlainTextEditor();
        edit.init();
        return edit;
    }

    public void dispose() {
        this.destroy();
    }
}

