/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.viewer;

import de.miethxml.hawron.io.FileMatcher;
import de.miethxml.toolkit.component.Configurable;
import de.miethxml.toolkit.repository.ui.viewer.RepositoryViewer;
import de.miethxml.toolkit.repository.ui.viewer.ViewerCloseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ExternalViewer
implements RepositoryViewer,
Configurable {
    public static String PLATFORM_ALL = "all";
    private String command = "";
    private String name = "";
    private List handles;
    private String platform = "";
    private Icon icon;
    private String open = "";
    private String iconurl = "";
    private String file = "";
    private String execute = "";
    private String start = "";
    private String end = "";
    private FileMatcher matcher = new FileMatcher();

    public ExternalViewer() {
        this.handles = new ArrayList();
        this.platform = PLATFORM_ALL;
    }

    public void init() {
    }

    public void setup() {
    }

    public JComponent getSetup() {
        return null;
    }

    public boolean isSetup() {
        return this.isSupportedPlatform();
    }

    public void setContextPath(String path) {
    }

    public void setVisible(boolean state) {
        this.execute = String.valueOf(this.start) + this.file + this.end;
        try {
            Runtime.getRuntime().exec(this.execute);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void open(String file) {
        this.file = file;
    }

    public boolean isSupported(String f) {
        return this.matcher.matches(f);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getToolTip(String lang) {
        return this.name;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
        if (command.indexOf("%s") > 0) {
            this.start = command.substring(0, command.indexOf("%s"));
            this.end = command.substring(command.indexOf("%s") + 2);
        } else {
            this.start = String.valueOf(command) + " ";
            this.end = "";
        }
    }

    public List getHandles() {
        return this.handles;
    }

    public void setHandles(List handles) {
        this.handles = handles;
        this.matcher.setPattern((Collection)this.handles);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setIcon(String file) {
        this.iconurl = file;
        this.icon = new ImageIcon(file);
    }

    public String getIconURL() {
        return this.iconurl;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public boolean isSupportedPlatform() {
        if (this.platform.equals(PLATFORM_ALL)) {
            return true;
        }
        String os = System.getProperty("os.name");
        return os.indexOf(this.platform) != -1;
    }

    public void addHandle(String handle) {
        this.handles.add(handle);
    }

    private void prepareCommand() {
    }

    public void addViewerCloseListener(ViewerCloseListener listener) {
    }

    public RepositoryViewer createNewViewer() {
        ExternalViewer viewer = new ExternalViewer();
        viewer.setCommand(this.getCommand());
        viewer.setIcon(this.getIcon());
        viewer.setHandles(this.getHandles());
        viewer.setName(this.getName());
        return viewer;
    }

    public void removeViewerCloseListener(ViewerCloseListener listener) {
    }
}

