/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.viewer;

import de.miethxml.toolkit.repository.ui.viewer.RepositoryViewer;
import de.miethxml.toolkit.repository.ui.viewer.ViewerCloseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class HTMLViewer
implements RepositoryViewer {
    private String[] supported = new String[]{".htm", ".html", ".xhtml", ".xml"};
    private String command = "";
    boolean foundBrowser = false;

    public void init() {
        this.determineBrowser();
    }

    public boolean setup() {
        return false;
    }

    public JComponent getSetup() {
        return null;
    }

    public void setContextPath(String path) {
    }

    public void setVisible(boolean state) {
    }

    public void open(String file) {
        try {
            Runtime.getRuntime().exec(String.valueOf(this.command) + " " + file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isSupported(String file) {
        int i = 0;
        while (i < this.supported.length) {
            if (file.endsWith(this.supported[i]) && this.foundBrowser) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Icon getIcon() {
        ImageIcon icon = new ImageIcon("icons/browser.gif");
        return icon;
    }

    public String getToolTip(String lang) {
        return "HtmlViewer";
    }

    private void determineBrowser() {
        String os = System.getProperty("os.name");
        if (os.indexOf("indows") > -1) {
            this.command = "rundll32 url.dll,FileProtocolHandler ";
            this.foundBrowser = true;
        } else {
            String[] browsers = new String[]{"/usr/bin/epiphany", "/usr/bin/mozilla", "/usr/bin/galeon", "/usr/kde/3.1/bin/konqueror", "/usr/kde/3/bin/konqueror", "/usr/bin/netscape"};
            int i = 0;
            while (i < browsers.length) {
                File f = new File(browsers[i]);
                if (f.exists() && f.isFile()) {
                    this.command = browsers[i];
                    this.foundBrowser = true;
                    return;
                }
                ++i;
            }
        }
    }

    public void addViewerCloseListener(ViewerCloseListener listener) {
    }

    public RepositoryViewer createNewViewer() {
        HTMLViewer viewer = new HTMLViewer();
        viewer.init();
        return viewer;
    }

    public void removeViewerCloseListener(ViewerCloseListener listener) {
    }
}

