/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.viewer;

import de.miethxml.toolkit.component.Configurable;
import de.miethxml.toolkit.component.GuiConfigurable;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.gui.ButtonPanel;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.locale.LocaleChangeListener;
import de.miethxml.toolkit.locale.LocaleService;
import de.miethxml.toolkit.plugins.PluginReceiver;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.ui.editor.EditorAction;
import de.miethxml.toolkit.repository.ui.viewer.ExternalViewer;
import de.miethxml.toolkit.repository.ui.viewer.ExternalViewerManager;
import de.miethxml.toolkit.repository.ui.viewer.ExternalViewerSetup;
import de.miethxml.toolkit.repository.ui.viewer.RepositoryViewer;
import de.miethxml.toolkit.repository.ui.viewer.ViewerAction;
import de.miethxml.toolkit.setup.SetupProcessListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class ViewerManager
implements PluginReceiver,
GuiConfigurable,
LocaleChangeListener,
RepositorySelectionListener,
SetupProcessListener {
    private Hashtable viewers = new Hashtable();
    private ArrayList brokenViewers = new ArrayList();
    private ArrayList setupViewers = new ArrayList();
    private ArrayList actions = new ArrayList();
    private ArrayList externalViewers = new ArrayList();
    private ButtonPanel buttonpanel;
    private JMenu menu;
    private ExternalViewerManager exManager;
    private Collection interfaces = new HashSet();
    private boolean checksupportedextensions = true;
    private ExternalViewerSetup setup = new ExternalViewerSetup();
    private LocaleService locale;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ViewerManager(LocaleService locale) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.miethxml.toolkit.repository.ui.viewer.RepositoryViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.interfaces.add(clazz.getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("de.miethxml.toolkit.repository.ui.viewer.CacheableViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.interfaces.add(clazz2.getName());
        this.locale = locale;
    }

    public void initialize() {
        this.buttonpanel = new ButtonPanel("viewer.buttonpanel.menu.title");
        this.buttonpanel.init();
        this.menu = new JMenu(this.locale.getString("viewer.buttonpanel.menu.title", "Viewers"));
        this.exManager = new ExternalViewerManager();
        this.exManager.initialize();
        this.setup.setExternalViewerManager(this.exManager);
        this.setup.initialize();
        this.initViewers();
    }

    public void dispose() {
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            ViewerAction action = (ViewerAction)e.nextElement();
            action.destroy();
        }
    }

    public Collection getInterfaces() {
        return this.interfaces;
    }

    public void addPlugin(Object obj) {
        RepositoryViewer viewer = (RepositoryViewer)obj;
        this.addViewer(viewer);
    }

    public void removePlugin(Object obj) {
    }

    public boolean isSetup() {
        return true;
    }

    public void setup() {
        RepositoryViewer view;
        Iterator i = this.brokenViewers.iterator();
        while (i.hasNext()) {
            RepositoryViewer viewer = (RepositoryViewer)i.next();
            Configurable conf = (Configurable)((Object)viewer);
            conf.setup();
            if (!conf.isSetup()) continue;
            this.addViewer(viewer);
            i.remove();
            this.setupViewers.add(viewer);
        }
        i = this.setupViewers.iterator();
        while (i.hasNext()) {
            Configurable conf = (Configurable)i.next();
            conf.setup();
            if (conf.isSetup()) continue;
            view = (RepositoryViewer)((Object)conf);
            this.buttonpanel.removeAction((Action)this.viewers.get(view));
            i.remove();
            this.brokenViewers.add(view);
        }
        i = this.externalViewers.iterator();
        while (i.hasNext()) {
            RepositoryViewer view2 = (RepositoryViewer)i.next();
            this.buttonpanel.removeAction((Action)this.viewers.get(view2));
            i.remove();
        }
        this.externalViewers.clear();
        int x = 0;
        while (x < this.exManager.getViewerCount()) {
            view = this.exManager.getViewer(x);
            if (((ExternalViewer)view).isSupportedPlatform()) {
                this.addViewer(view);
                this.externalViewers.add(view);
            }
            ++x;
        }
    }

    public void langChanged() {
        this.menu.setText(LocaleImpl.getInstance().getString("viewer.buttonpanel.menu.title"));
    }

    private void initViewers() {
        this.viewers.clear();
        this.actions.clear();
        int x = 0;
        while (x < this.exManager.getViewerCount()) {
            ExternalViewer viewer = this.exManager.getViewer(x);
            if (viewer.isSupportedPlatform()) {
                this.addViewer(viewer);
                this.externalViewers.add(viewer);
            }
            ++x;
        }
    }

    private void addViewer(RepositoryViewer viewer) {
        if (viewer instanceof Configurable) {
            Configurable conf = (Configurable)((Object)viewer);
            conf.setup();
            if (conf.isSetup()) {
                this.setupViewers.add(viewer);
            } else {
                this.brokenViewers.add(viewer);
                return;
            }
        }
        viewer.init();
        ViewerAction action = new ViewerAction(viewer);
        action.setCheckSupportedExtensions(this.checksupportedextensions);
        this.actions.add(action);
        this.viewers.put(viewer, action);
        this.buttonpanel.addAction(action);
        this.menu.add(action);
    }

    public JComponent getButtonPanel() {
        return this.buttonpanel;
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public void setCheckSupportedExtensions(boolean b) {
        this.checksupportedextensions = b;
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            ViewerAction action = (ViewerAction)i.next();
            action.setCheckSupportedExtensions(b);
        }
    }

    public void endSetup() {
        this.setup();
    }

    public void startSetup() {
    }

    public JMenu getViewerMenu() {
        return this.menu;
    }

    public void directorySelected(Reloadable model, FileModel directory) {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            EditorAction action = (EditorAction)i.next();
            action.directorySelected(model, directory);
        }
    }

    public void fileSelected(Reloadable model, FileModel file) {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            EditorAction action = (EditorAction)i.next();
            action.fileSelected(model, file);
        }
    }

    public void unselect() {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            EditorAction action = (EditorAction)i.next();
            action.unselect();
        }
    }

    public void localeChanged(LocaleService locale) {
        this.menu.setText(locale.getString("action.buttonpanel.menu.title", "Editors"));
    }

    public String getLabel() {
        return this.setup.getLabel();
    }

    public JComponent getSetupComponent() {
        return this.setup.getSetupComponent();
    }
}

