/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui;

import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.gui.LocaleMenu;
import de.miethxml.toolkit.gui.LocaleMenuItem;
import de.miethxml.toolkit.ui.MenuBarManager;
import de.miethxml.toolkit.ui.builder.SAXMenuBuilder;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class EditableMenuBar
extends JMenuBar
implements Serviceable,
MenuBarManager {
    private ServiceManager manager;
    private Hashtable menus = new Hashtable();
    private Hashtable menuitems = new Hashtable();
    private Hashtable relations = new Hashtable();
    private boolean helpMenuPresent = false;
    private String HELPMENUROLE = "menu.help";
    public String MENU_CONFIG = "conf/gui.xml";

    public EditableMenuBar() {
        this.initialize();
    }

    public void addActionListener(String role, ActionListener l) {
        if (this.menuitems.containsKey(role)) {
            LocaleMenuItem mi = (LocaleMenuItem)this.menuitems.get(role);
            mi.addActionListener(l);
        } else if (this.menus.containsKey(role)) {
            LocaleMenu m = (LocaleMenu)this.menus.get(role);
            m.addActionListener(l);
        }
    }

    public void removeActionListener(String role, ActionListener l) {
        LocaleMenuItem m = (LocaleMenuItem)this.menuitems.get(role);
        if (m == null) {
            m = (LocaleMenuItem)this.menus.get(role);
        }
        if (m != null) {
            m.removeActionListener(l);
        }
    }

    public void addMenu(String parentrole, String role, String icon) {
        LocaleMenu m = null;
        if (!this.menus.containsKey(role)) {
            m = new LocaleMenu(role);
            if (icon != null && icon.length() > 0) {
                m.setIcon(new ImageIcon(icon));
            }
            if (parentrole.length() > 0) {
                LocaleMenu menu = (LocaleMenu)this.menus.get(parentrole);
                menu.add(m);
            } else if (role.equals(this.HELPMENUROLE)) {
                this.setHelpMenu(m);
            } else if (this.helpMenuPresent) {
                this.add((Component)m, this.getComponentCount() - 2);
            } else {
                this.add(m);
            }
            this.menus.put(role, m);
            this.relations.put(role, parentrole);
            m.setText(LocaleImpl.getInstance().getString(role));
            m.setActionCommand(role);
        }
    }

    public void addMenu(String parentrole, String role, LocaleMenu m) {
        if (parentrole.length() > 0) {
            LocaleMenu menu = (LocaleMenu)this.menus.get(parentrole);
            menu.add(m);
        } else if (role.equals(this.HELPMENUROLE)) {
            this.setHelpMenu(m);
        } else if (this.helpMenuPresent) {
            this.add((Component)m, this.getComponentCount() - 2);
        } else {
            this.add(m);
        }
        this.menus.put(role, m);
        this.relations.put(role, parentrole);
        m.setActionCommand(role);
    }

    public void addMenu(String parentrole, String role) {
        this.addMenu(parentrole, role, "");
    }

    public void addMenu(String role) {
        this.addMenu("", role, "");
    }

    public void addMenuItem(String parentrole, String role, String icon) {
        this.addMenuItem(parentrole, role, icon, null);
    }

    public void addMenuItem(String parentrole, String role, String icon, KeyStroke key) {
        LocaleMenuItem mi = null;
        if (this.menuitems.containsKey(role)) {
            mi = (LocaleMenuItem)this.menuitems.get(role);
        } else {
            mi = new LocaleMenuItem(role);
            if (icon != null && icon.length() > 0) {
                mi.setIcon(new ImageIcon(icon));
            }
            JMenu menu = (JMenu)this.menus.get(parentrole);
            menu.add(mi);
            this.menuitems.put(role, mi);
            this.relations.put(role, parentrole);
        }
        mi.setActionCommand(role);
        if (key != null) {
            mi.setAccelerator(key);
        }
    }

    public void addMenuItem(String parentrole, String role, JMenuItem mi) {
        if (this.menuitems.containsKey(role)) {
            mi = (LocaleMenuItem)this.menuitems.get(role);
        } else {
            JMenu menu = (JMenu)this.menus.get(parentrole);
            menu.add(mi);
            this.menuitems.put(role, mi);
            this.relations.put(role, parentrole);
        }
    }

    public void addMenuItem(String parentrole, String role) {
        this.addMenuItem(parentrole, role, "");
    }

    public void removeMenu(String role) {
        String parent = (String)this.relations.get(role);
        if (parent.length() > 0) {
            LocaleMenu menu = (LocaleMenu)this.menus.get(parent);
            menu.remove((LocaleMenu)this.menus.get(role));
            this.menus.remove(role);
        } else {
            this.remove((LocaleMenu)this.menus.get(role));
        }
    }

    public void removeMenuItem(String role) {
        String parent = (String)this.relations.get(role);
        LocaleMenu menu = (LocaleMenu)this.menus.get(parent);
        menu.remove((LocaleMenuItem)this.menuitems.get(role));
        this.menuitems.remove(role);
    }

    public void addSeparator(String parent) {
        LocaleMenu menu = (LocaleMenu)this.menus.get(parent);
        menu.add(new JSeparator());
    }

    public void addMenuLabel(String role, String label) {
        LocaleImpl.getInstance().setString(role, label);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void initialize() {
        SAXMenuBuilder sb = new SAXMenuBuilder();
        sb.setMenuBar(this);
        sb.buildMenu(this.MENU_CONFIG);
    }

    public void setHelpMenu(LocaleMenu help) {
        if (!this.helpMenuPresent) {
            this.add(Box.createHorizontalGlue());
            this.add(help);
            this.helpMenuPresent = true;
        } else {
            this.remove(this.getComponentCount() - 1);
            this.add(help);
        }
    }

    public void setMenuAction(String role, Action action) {
        LocaleMenu m = (LocaleMenu)this.menus.get(role);
        m.setAction(action);
        m.setActionCommand(role);
    }

    public void setMenuItemAction(String role, Action action) {
        LocaleMenuItem mi = (LocaleMenuItem)this.menuitems.get(role);
        mi.setAction(action);
        mi.setActionCommand(role);
    }

    public JMenuBar getMenuBar() {
        return this;
    }
}

