/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui;

import de.miethxml.toolkit.ui.ButtonGradientTitledLabel;
import de.miethxml.toolkit.ui.SimpleSplitPaneUI;
import de.miethxml.toolkit.ui.SmallShadowBorder;
import de.miethxml.toolkit.ui.event.PopupActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class PanelFactory {
    public static JPanel createTitledPanel(JComponent view, String title, String icon, JPopupMenu menu) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new SmallShadowBorder());
        ButtonGradientTitledLabel bpanel = new ButtonGradientTitledLabel(title);
        if (icon != null) {
            bpanel.addComponent(new JLabel(new ImageIcon(icon)), 2);
        }
        JButton button = new JButton(new ImageIcon("icons/prefs01.gif"));
        button.addActionListener(new PopupActionListener(menu));
        button.setUI(new BasicButtonUI());
        bpanel.addComponent(button);
        panel.add((Component)bpanel, "North");
        panel.add((Component)view, "Center");
        return panel;
    }

    public static JPanel createTitledPanel(JComponent view, String title, String icon) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new SmallShadowBorder());
        ButtonGradientTitledLabel bpanel = new ButtonGradientTitledLabel(title);
        if (icon != null) {
            bpanel.addComponent(new JLabel(new ImageIcon(icon)), 2);
        } else {
            bpanel.setPadding(10);
        }
        panel.add((Component)bpanel, "North");
        panel.add((Component)view, "Center");
        return panel;
    }

    public static JSplitPane createOneTouchSplitPane() {
        return PanelFactory.createOneTouchSplitPane(1);
    }

    public static JSplitPane createOneTouchSplitPane(int orientation) {
        JSplitPane pane = new JSplitPane(orientation);
        pane.setOpaque(false);
        pane.setOneTouchExpandable(true);
        pane.setUI(new SimpleSplitPaneUI());
        pane.setDividerSize(11);
        pane.setBorder(BorderFactory.createEmptyBorder());
        return pane;
    }

    public static JSplitPane createDefaultSplitPane() {
        return PanelFactory.createDefaultSplitPane(1);
    }

    public static JSplitPane createDefaultSplitPane(int orientation) {
        JSplitPane pane = new JSplitPane(orientation);
        pane.setOpaque(false);
        BasicSplitPaneUI ui = new BasicSplitPaneUI();
        pane.setUI(ui);
        ui.getDivider().setBorder(null);
        pane.setBorder(BorderFactory.createEmptyBorder());
        return pane;
    }
}

