/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.wizard.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.toolkit.wizard.WizardConstants;
import de.miethxml.toolkit.wizard.ui.TimerUI;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class DownloadUI {
    protected ResourceBundle resource = WizardConstants.LOCALE;
    private JProgressBar progressBar;
    private JLabel step;
    private JLabel transfered;
    private JLabel time;
    private JLabel rate;
    private boolean cancel;
    private TimerUI timer;
    private NumberFormat sizeformat = NumberFormat.getInstance();

    public JComponent getView() {
        FormLayout layout = new FormLayout("9dlu,pref,2dlu,fill:pref:grow,9dlu,", "15dlu,p,3dlu,p,3dlu,p,3dlu,p,15dlu,p,9dlu");
        PanelBuilder panelbuilder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        this.step = new JLabel("");
        panelbuilder.add((Component)this.step, cc.xywh(2, 2, 3, 1));
        panelbuilder.addLabel(this.resource.getString("wizard.component.downloader.time"), cc.xy(2, 4));
        this.time = new JLabel("");
        panelbuilder.add((Component)this.time, cc.xy(4, 4));
        panelbuilder.addLabel(this.resource.getString("wizard.component.downloader.size"), cc.xy(2, 6));
        this.transfered = new JLabel("");
        panelbuilder.add((Component)this.transfered, cc.xy(4, 6));
        panelbuilder.addLabel(this.resource.getString("wizard.component.downloader.speed"), cc.xy(2, 8));
        this.rate = new JLabel("");
        panelbuilder.add((Component)this.rate, cc.xy(4, 8));
        this.progressBar = new JProgressBar();
        panelbuilder.add((Component)this.progressBar, cc.xywh(2, 10, 3, 1));
        this.timer = new TimerUI();
        return panelbuilder.getPanel();
    }

    public void setText(String text) {
        this.step.setText(text);
    }

    public void download(String url, String dest) throws Exception {
        boolean complete = true;
        String filename = null;
        this.cancel = false;
        URL source = new URL(url);
        filename = source.getFile();
        if (filename.lastIndexOf("/") > -1) {
            filename = filename.substring(filename.lastIndexOf("/") + 1);
        }
        URLConnection connection = source.openConnection();
        int filelength = connection.getContentLength();
        String contentLength = String.valueOf(this.sizeformat.format(filelength / 1024)) + "KB";
        this.timer.begin(this.time, filelength);
        long startTime = System.currentTimeMillis();
        this.step.setText(String.valueOf(this.step.getText()) + " " + filename);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(filelength);
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(connection.getInputStream());
            out = new BufferedOutputStream(new FileOutputStream(String.valueOf(dest) + File.separator + filename));
            int current = 0;
            boolean process = false;
            int length = -1;
            byte[] bytes = new byte[1024];
            while ((length = in.read(bytes, 0, bytes.length)) != -1 && !this.cancel) {
                ((BufferedOutputStream)out).write(bytes, 0, length);
                this.progressBar.setValue(current += length);
                this.transfered.setText(String.valueOf(this.sizeformat.format(current / 1024)) + "KB of " + contentLength);
                this.timer.setValue(current);
                double speed = (double)((long)current / (System.currentTimeMillis() - startTime + 1L)) * 0.9765625;
                this.rate.setText(String.valueOf(this.sizeformat.format(speed)) + " KB/s");
            }
            in.close();
            ((BufferedOutputStream)out).flush();
            out.close();
            this.timer.end();
            in = null;
            out = null;
            complete = true;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void interrupt() {
        this.cancel = true;
        this.timer.end();
    }
}

