/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.wizard.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.toolkit.wizard.WizardConstants;
import de.miethxml.toolkit.wizard.ui.TimerUI;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.apache.commons.compress.tar.TarEntry;
import org.apache.commons.compress.tar.TarInputStream;

public class ExtractUI {
    protected ResourceBundle resource = WizardConstants.LOCALE;
    private JProgressBar progressBar;
    private JLabel step;
    private JLabel bytes;
    private JLabel time;
    private boolean cancel;
    private String rootDir;
    private TimerUI timer;

    public JComponent getView() {
        FormLayout layout = new FormLayout("9dlu,pref,2dlu,pref:grow,9dlu,", "15dlu,p,3dlu,p,3dlu,p,15dlu,p,9dlu");
        PanelBuilder panelbuilder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        this.step = new JLabel("");
        panelbuilder.add((Component)this.step, cc.xywh(2, 2, 3, 1));
        panelbuilder.add((Component)new JLabel(this.resource.getString("wizard.component.unpack.count")), cc.xy(2, 4));
        this.bytes = new JLabel("");
        panelbuilder.add((Component)this.bytes, cc.xy(4, 4));
        panelbuilder.add((Component)new JLabel(this.resource.getString("wizard.component.unpack.time")), cc.xy(2, 6));
        this.time = new JLabel("");
        panelbuilder.add((Component)this.time, cc.xy(4, 6));
        this.progressBar = new JProgressBar();
        panelbuilder.add((Component)this.progressBar, cc.xywh(2, 8, 3, 1));
        this.timer = new TimerUI();
        return panelbuilder.getPanel();
    }

    public void setText(String text) {
        this.step.setText(text);
    }

    public void extractArchiv(String file, String dest) throws Exception {
        this.cancel = false;
        if (file.endsWith(".zip")) {
            this.extractZipArchiv(file, dest);
        } else if (file.endsWith(".tar.gz") || file.endsWith(".tgz")) {
            this.extractTarArchiv(file, dest);
        }
    }

    public void interrupt() {
        this.cancel = true;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    private void extractZipArchiv(String file, String destDir) throws Exception {
        ZipFile ziparchiv = new ZipFile(file);
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        int process = 0;
        int totalCount = ziparchiv.size();
        boolean progress = false;
        Enumeration<? extends ZipEntry> e = ziparchiv.entries();
        this.progressBar.setMaximum(totalCount);
        this.timer.begin(this.time, totalCount);
        while (e.hasMoreElements() && !this.cancel) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) {
                File dir;
                String name = entry.getName();
                if (name.substring(0, name.length() - 1).indexOf("/") < 0) {
                    System.out.println("setting root");
                    this.rootDir = this.rootDir == null ? String.valueOf(destDir) + File.separator + entry.getName() : destDir;
                    System.out.println("setting root=" + this.rootDir);
                }
                if (!(dir = new File(String.valueOf(destDir) + File.separator + entry.getName())).exists()) {
                    dir.mkdirs();
                }
            } else {
                BufferedInputStream in = new BufferedInputStream(ziparchiv.getInputStream(entry));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(String.valueOf(destDir) + File.separator + entry.getName()));
                int current = 0;
                int length = -1;
                byte[] bytes = new byte[1024];
                while ((length = in.read(bytes, 0, bytes.length)) != -1 && !this.cancel) {
                    out.write(bytes, 0, length);
                    current += length;
                }
                in.close();
                out.flush();
                out.close();
                in = null;
                out = null;
            }
            this.timer.next();
            this.bytes.setText(String.valueOf(++process) + "/" + totalCount);
            this.progressBar.setValue(process);
        }
    }

    private void extractTarArchiv(String file, String destDir) throws Exception {
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(file));
        TarInputStream tararchiv = new TarInputStream((InputStream)in);
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setIndeterminate(true);
        int process = 0;
        int totalCount = tararchiv.getRecordSize();
        boolean progress = false;
        this.progressBar.setMaximum(totalCount);
        TarEntry entry = null;
        while ((entry = tararchiv.getNextEntry()) != null && !this.cancel) {
            String name = entry.getName();
            if (entry.isDirectory()) {
                File dir;
                if (name.substring(0, name.length() - 1).indexOf("/") < 0) {
                    System.out.println("setting root");
                    this.rootDir = this.rootDir == null ? String.valueOf(destDir) + File.separator + name : destDir;
                }
                if (!(dir = new File(String.valueOf(destDir) + File.separator + entry.getName())).exists()) {
                    dir.mkdirs();
                }
            } else {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(String.valueOf(destDir) + File.separator + entry.getName()));
                int current = 0;
                int length = -1;
                byte[] bytes = new byte[1024];
                while ((length = tararchiv.read(bytes, 0, bytes.length)) != -1 && !this.cancel) {
                    out.write(bytes, 0, length);
                    current += length;
                }
                out.flush();
                out.close();
                out = null;
            }
            this.bytes.setText("" + ++process);
            this.progressBar.setValue(process);
        }
        this.progressBar.setIndeterminate(false);
    }
}

