/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;

public abstract class TimeContainer
extends TimedElement {
    protected LinkedList children = new LinkedList();

    public void addChild(TimedElement timedElement) {
        this.children.add(timedElement);
        timedElement.parent = this;
        this.setRoot(timedElement, this.root);
        this.root.fireElementAdded(timedElement);
        this.root.currentIntervalWillUpdate();
    }

    protected void setRoot(TimedElement timedElement, TimedDocumentRoot timedDocumentRoot) {
        timedElement.root = timedDocumentRoot;
        if (timedElement instanceof TimeContainer) {
            TimeContainer timeContainer = (TimeContainer)timedElement;
            TimedElement[] timedElementArray = timeContainer.getChildren();
            for (int i = 0; i < timedElementArray.length; ++i) {
                this.setRoot(timedElementArray[i], timedDocumentRoot);
            }
        }
    }

    public void removeChild(TimedElement timedElement) {
        this.children.remove(timedElement);
        timedElement.parent = null;
        this.setRoot(timedElement, null);
        this.root.fireElementRemoved(timedElement);
        this.root.currentIntervalWillUpdate();
    }

    public TimedElement[] getChildren() {
        return this.children.toArray(new TimedElement[0]);
    }

    protected float sampleAt(float f, boolean bl) {
        super.sampleAt(f, bl);
        return this.sampleChildren(f, bl);
    }

    protected float sampleChildren(float f, boolean bl) {
        float f2 = Float.POSITIVE_INFINITY;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TimedElement timedElement = (TimedElement)iterator.next();
            float f3 = timedElement.sampleAt(f, bl);
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    protected void reset(boolean bl) {
        super.reset(bl);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TimedElement timedElement = (TimedElement)iterator.next();
            timedElement.reset(bl);
        }
    }

    protected boolean isConstantAnimation() {
        return false;
    }

    public abstract float getDefaultBegin(TimedElement var1);
}

