/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.ArrayList;
import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.SimpleAnimation;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGAnimationElementBridge;
import org.apache.batik.dom.anim.AnimationTarget;

public class SVGAnimateElementBridge
extends SVGAnimationElementBridge {
    public String getLocalName() {
        return "animate";
    }

    public Bridge getInstance() {
        return new SVGAnimateElementBridge();
    }

    protected AbstractAnimation createAnimation(AnimationTarget animationTarget) {
        AnimatableValue animatableValue = this.parseAnimatableValue("from");
        AnimatableValue animatableValue2 = this.parseAnimatableValue("to");
        AnimatableValue animatableValue3 = this.parseAnimatableValue("by");
        return new SimpleAnimation(this.timedElement, this, this.parseCalcMode(), this.parseKeyTimes(), this.parseKeySplines(), this.parseAdditive(), this.parseAccumulate(), this.parseValues(), animatableValue, animatableValue2, animatableValue3);
    }

    protected int parseCalcMode() {
        String string = this.element.getAttributeNS(null, "calcMode");
        if (string.length() == 0) {
            return this.getDefaultCalcMode();
        }
        if (string.equals("linear")) {
            return 1;
        }
        if (string.equals("discrete")) {
            return 0;
        }
        if (string.equals("paced")) {
            return 2;
        }
        if (string.equals("spline")) {
            return 3;
        }
        throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"calcMode", string});
    }

    protected boolean parseAdditive() {
        String string = this.element.getAttributeNS(null, "additive");
        if (string.length() == 0 || string.equals("replace")) {
            return false;
        }
        if (string.equals("sum")) {
            return true;
        }
        throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"additive", string});
    }

    protected boolean parseAccumulate() {
        String string = this.element.getAttributeNS(null, "accumulate");
        if (string.length() == 0 || string.equals("none")) {
            return false;
        }
        if (string.equals("sum")) {
            return true;
        }
        throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"accumulate", string});
    }

    protected AnimatableValue[] parseValues() {
        Object object;
        boolean bl = this.animationType == 1;
        String string = this.element.getAttributeNS(null, "values");
        int n = string.length();
        if (n == 0) {
            return null;
        }
        ArrayList<AnimatableValue[]> arrayList = new ArrayList<AnimatableValue[]>(7);
        int n2 = 0;
        int n3 = 0;
        block0: while (n2 < n) {
            int n4;
            while (string.charAt(n2) == ' ') {
                if (++n2 != n) continue;
                break block0;
            }
            n3 = n2++;
            if (n2 != n) {
                char c = string.charAt(n2);
                while (c != ';' && ++n2 != n) {
                    c = string.charAt(n2);
                }
            }
            if (!this.checkValueType((AnimatableValue)(object = this.eng.parseAnimatableValue(this.element, this.animationTarget, this.attributeNamespaceURI, this.attributeLocalName, bl, string.substring(n3, n4 = n2++))))) {
                throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"values", string});
            }
            arrayList.add((AnimatableValue[])object);
        }
        object = new AnimatableValue[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    protected float[] parseKeyTimes() {
        String string = this.element.getAttributeNS(null, "keyTimes");
        int n = string.length();
        if (n == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(7);
        int n2 = 0;
        int n3 = 0;
        block2: while (n2 < n) {
            while (string.charAt(n2) == ' ') {
                if (++n2 != n) continue;
                break block2;
            }
            n3 = n2++;
            if (n2 != n) {
                char c = string.charAt(n2);
                while (c != ' ' && c != ';' && ++n2 != n) {
                    c = string.charAt(n2);
                }
            }
            int n4 = n2++;
            try {
                float f = Float.parseFloat(string.substring(n3, n4));
                arrayList.add(new Float(f));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"keyTimes", string});
            }
        }
        n = arrayList.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = ((Float)arrayList.get(i)).floatValue();
        }
        return fArray;
    }

    protected float[] parseKeySplines() {
        String string = this.element.getAttributeNS(null, "keySplines");
        int n = string.length();
        if (n == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(7);
        int n2 = 0;
        int n3 = 0;
        block2: while (n2 < n) {
            while (string.charAt(n2) == ' ') {
                if (++n2 != n) continue;
                break block2;
            }
            n3 = n2++;
            if (n2 != n) {
                char c = string.charAt(n2);
                while (c != ' ' && c != ';' && ++n2 != n) {
                    c = string.charAt(n2);
                }
            }
            int n4 = n2++;
            try {
                float f = Float.parseFloat(string.substring(n3, n4));
                arrayList.add(new Float(f));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"keySplines", string});
            }
        }
        n = arrayList.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = ((Float)arrayList.get(i)).floatValue();
        }
        return fArray;
    }

    protected int getDefaultCalcMode() {
        return 1;
    }

    protected boolean canAnimateType(int n) {
        return true;
    }
}

