/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableNumberOptionalNumberValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGOMAnimatedNumber;
import org.apache.batik.dom.svg.SVGOMFilterPrimitiveStandardAttributes;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedInteger;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGFETurbulenceElement;

public class SVGOMFETurbulenceElement
extends SVGOMFilterPrimitiveStandardAttributes
implements SVGFETurbulenceElement {
    protected static final String[] STITCH_TILES_VALUES = new String[]{"", "stitch", "noStitch"};
    protected static final String[] TYPE_VALUES = new String[]{"", "fractalNoise", "turbulence"};

    protected SVGOMFETurbulenceElement() {
    }

    public SVGOMFETurbulenceElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public String getLocalName() {
        return "feTurbulence";
    }

    public SVGAnimatedNumber getBaseFrequencyX() {
        throw new UnsupportedOperationException("SVGFETurbulenceElement.getBaseFrequencyX is not implemented");
    }

    public SVGAnimatedNumber getBaseFrequencyY() {
        throw new UnsupportedOperationException("SVGFETurbulenceElement.getBaseFrequencyY is not implemented");
    }

    public SVGAnimatedInteger getNumOctaves() {
        return this.getAnimatedIntegerAttribute(null, "numOctaves", 1);
    }

    public SVGAnimatedNumber getSeed() {
        return this.getAnimatedNumberAttribute(null, "seed", 0.0f);
    }

    public SVGAnimatedEnumeration getStitchTiles() {
        return this.getAnimatedEnumerationAttribute(null, "stitchTiles", STITCH_TILES_VALUES, (short)2);
    }

    public SVGAnimatedEnumeration getType() {
        return this.getAnimatedEnumerationAttribute(null, "type", TYPE_VALUES, (short)2);
    }

    protected Node newNode() {
        return new SVGOMFETurbulenceElement();
    }

    public boolean isAttributeAnimatable(String string, String string2) {
        if (string == null && (string2.equals("baseFrequency") || string2.equals("numOctaves") || string2.equals("seed") || string2.equals("stitchTiles") || string2.equals("type"))) {
            return true;
        }
        return super.isAttributeAnimatable(string, string2);
    }

    public int getAttributeType(String string, String string2) {
        if (string == null) {
            if (string2.equals("baseFrequency")) {
                return 4;
            }
            if (string2.equals("numOctaves")) {
                return 1;
            }
            if (string2.equals("seed")) {
                return 2;
            }
            if (string2.equals("stitchTiles") || string2.equals("type")) {
                return 15;
            }
        }
        return super.getAttributeType(string, string2);
    }

    public void updateAttributeValue(String string, String string2, AnimatableValue animatableValue) {
        if (string == null) {
            if (string2.equals("type")) {
                this.updateEnumerationAttributeValue(this.getType(), animatableValue);
                return;
            }
            if (string2.equals("numOctaves")) {
                this.updateIntegerAttributeValue(this.getNumOctaves(), animatableValue);
                return;
            }
            if (string2.equals("seed")) {
                this.updateNumberAttributeValue(this.getSeed(), animatableValue);
                return;
            }
            if (string2.equals("stitchTiles")) {
                this.updateEnumerationAttributeValue(this.getStitchTiles(), animatableValue);
                return;
            }
            if (string2.equals("baseFrequency")) {
                if (animatableValue == null) {
                    this.updateNumberAttributeValue(this.getBaseFrequencyX(), null);
                    this.updateNumberAttributeValue(this.getBaseFrequencyY(), null);
                } else {
                    AnimatableNumberOptionalNumberValue animatableNumberOptionalNumberValue = (AnimatableNumberOptionalNumberValue)animatableValue;
                    SVGOMAnimatedNumber sVGOMAnimatedNumber = (SVGOMAnimatedNumber)this.getBaseFrequencyX();
                    sVGOMAnimatedNumber.setAnimatedValue(animatableNumberOptionalNumberValue.getNumber());
                    sVGOMAnimatedNumber = (SVGOMAnimatedNumber)this.getBaseFrequencyY();
                    if (animatableNumberOptionalNumberValue.hasOptionalNumber()) {
                        sVGOMAnimatedNumber.setAnimatedValue(animatableNumberOptionalNumberValue.getOptionalNumber());
                    } else {
                        sVGOMAnimatedNumber.setAnimatedValue(animatableNumberOptionalNumberValue.getNumber());
                    }
                }
                return;
            }
        }
        super.updateAttributeValue(string, string2, animatableValue);
    }

    public AnimatableValue getUnderlyingValue(String string, String string2) {
        if (string == null) {
            if (string2.equals("type")) {
                return this.getBaseValue(this.getType());
            }
            if (string2.equals("numOctaves")) {
                return this.getBaseValue(this.getNumOctaves());
            }
            if (string2.equals("seed")) {
                return this.getBaseValue(this.getSeed());
            }
            if (string2.equals("stitchTiles")) {
                return this.getBaseValue(this.getStitchTiles());
            }
            if (string2.equals("baseFrequency")) {
                return this.getBaseValue(this.getBaseFrequencyX(), this.getBaseFrequencyY());
            }
        }
        return super.getUnderlyingValue(string, string2);
    }
}

