/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableNumberOptionalNumberValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.SVGExternalResourcesRequiredSupport;
import org.apache.batik.dom.svg.SVGOMAnimatedInteger;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.svg.SVGURIReferenceSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedInteger;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGFilterElement;

public class SVGOMFilterElement
extends SVGStylableElement
implements SVGFilterElement {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(4);
    protected static final String[] UNITS_VALUES;

    protected SVGOMFilterElement() {
    }

    public SVGOMFilterElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public String getLocalName() {
        return "filter";
    }

    public SVGAnimatedEnumeration getFilterUnits() {
        return this.getAnimatedEnumerationAttribute(null, "filterUnits", UNITS_VALUES, (short)2);
    }

    public SVGAnimatedEnumeration getPrimitiveUnits() {
        return this.getAnimatedEnumerationAttribute(null, "primitiveUnits", UNITS_VALUES, (short)1);
    }

    public SVGAnimatedLength getX() {
        return this.getAnimatedLengthAttribute(null, "x", "-10%", (short)2, false);
    }

    public SVGAnimatedLength getY() {
        return this.getAnimatedLengthAttribute(null, "y", "-10%", (short)1, false);
    }

    public SVGAnimatedLength getWidth() {
        return this.getAnimatedLengthAttribute(null, "width", "120%", (short)2, true);
    }

    public SVGAnimatedLength getHeight() {
        return this.getAnimatedLengthAttribute(null, "height", "120%", (short)1, true);
    }

    public SVGAnimatedInteger getFilterResX() {
        throw new UnsupportedOperationException("SVGFilterElement.getFilterResX is not implemented");
    }

    public SVGAnimatedInteger getFilterResY() {
        throw new UnsupportedOperationException("SVGFilterElement.getFilterResY is not implemented");
    }

    public void setFilterRes(int n, int n2) {
        throw new UnsupportedOperationException("SVGFilterElement.setFilterRes is not implemented");
    }

    public SVGAnimatedString getHref() {
        return SVGURIReferenceSupport.getHref(this);
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return SVGExternalResourcesRequiredSupport.getExternalResourcesRequired(this);
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang(this);
    }

    public void setXMLlang(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", string);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace(this);
    }

    public void setXMLspace(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMFilterElement();
    }

    public boolean isAttributeAnimatable(String string, String string2) {
        if (string == null && (string2.equals("externalResourcesRequired") || string2.equals("filterUnits") || string2.equals("primitiveUnits") || string2.equals("x") || string2.equals("y") || string2.equals("width") || string2.equals("height") || string2.equals("filterRes"))) {
            return true;
        }
        return super.isAttributeAnimatable(string, string2);
    }

    public int getAttributeType(String string, String string2) {
        if (string == null) {
            if (string2.equals("filterUnits") || string2.equals("primitiveUnits")) {
                return 15;
            }
            if (string2.equals("x") || string2.equals("y") || string2.equals("width") || string2.equals("height")) {
                return 3;
            }
            if (string2.equals("filterRes")) {
                return 4;
            }
        }
        return super.getAttributeType(string, string2);
    }

    protected short getAttributePercentageInterpretation(String string, String string2) {
        if (string == null) {
            if (string2.equals("x") || string2.equals("width")) {
                return 1;
            }
            if (string2.equals("y") || string2.equals("height")) {
                return 2;
            }
        }
        return super.getAttributePercentageInterpretation(string, string2);
    }

    public void updateAttributeValue(String string, String string2, AnimatableValue animatableValue) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                this.updateBooleanAttributeValue(this.getExternalResourcesRequired(), animatableValue);
                return;
            }
            if (string2.equals("filterUnits")) {
                this.updateEnumerationAttributeValue(this.getFilterUnits(), animatableValue);
                return;
            }
            if (string2.equals("primitiveUnits")) {
                this.updateEnumerationAttributeValue(this.getPrimitiveUnits(), animatableValue);
                return;
            }
            if (string2.equals("x")) {
                this.updateLengthAttributeValue(this.getX(), animatableValue);
                return;
            }
            if (string2.equals("y")) {
                this.updateLengthAttributeValue(this.getY(), animatableValue);
                return;
            }
            if (string2.equals("width")) {
                this.updateLengthAttributeValue(this.getWidth(), animatableValue);
                return;
            }
            if (string2.equals("height")) {
                this.updateLengthAttributeValue(this.getHeight(), animatableValue);
                return;
            }
            if (string2.equals("filterRes")) {
                if (animatableValue == null) {
                    this.updateIntegerAttributeValue(this.getFilterResX(), null);
                    this.updateIntegerAttributeValue(this.getFilterResY(), null);
                } else {
                    AnimatableNumberOptionalNumberValue animatableNumberOptionalNumberValue = (AnimatableNumberOptionalNumberValue)animatableValue;
                    SVGOMAnimatedInteger sVGOMAnimatedInteger = (SVGOMAnimatedInteger)this.getFilterResX();
                    sVGOMAnimatedInteger.setAnimatedValue(Math.round(animatableNumberOptionalNumberValue.getNumber()));
                    sVGOMAnimatedInteger = (SVGOMAnimatedInteger)this.getFilterResY();
                    if (animatableNumberOptionalNumberValue.hasOptionalNumber()) {
                        sVGOMAnimatedInteger.setAnimatedValue(Math.round(animatableNumberOptionalNumberValue.getOptionalNumber()));
                    } else {
                        sVGOMAnimatedInteger.setAnimatedValue(Math.round(animatableNumberOptionalNumberValue.getNumber()));
                    }
                }
                return;
            }
        }
        super.updateAttributeValue(string, string2, animatableValue);
    }

    public AnimatableValue getUnderlyingValue(String string, String string2) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                return this.getBaseValue(this.getExternalResourcesRequired());
            }
            if (string2.equals("filterUnits")) {
                return this.getBaseValue(this.getFilterUnits());
            }
            if (string2.equals("primitiveUnits")) {
                return this.getBaseValue(this.getPrimitiveUnits());
            }
            if (string2.equals("x")) {
                return this.getBaseValue(this.getX(), (short)1);
            }
            if (string2.equals("y")) {
                return this.getBaseValue(this.getY(), (short)2);
            }
            if (string2.equals("width")) {
                return this.getBaseValue(this.getWidth(), (short)1);
            }
            if (string2.equals("height")) {
                return this.getBaseValue(this.getHeight(), (short)2);
            }
            if (string2.equals("filterRes")) {
                return this.getBaseValue(this.getFilterResX(), this.getFilterResY());
            }
        }
        return super.getUnderlyingValue(string, string2);
    }

    static {
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns:xlink", "http://www.w3.org/1999/xlink");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "type", "simple");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "show", "other");
        attributeInitializer.addAttribute("http://www.w3.org/1999/xlink", "xlink", "actuate", "onLoad");
        UNITS_VALUES = new String[]{"", "userSpaceOnUse", "objectBoundingBox"};
    }
}

