/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFReader;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;

public class WMFRecordStore
extends AbstractWMFReader {
    private URL url;
    protected int numRecords;
    protected float vpX;
    protected float vpY;
    protected List records;
    private boolean _bext = true;

    public WMFRecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0.0f;
        this.vpY = 0.0f;
        this.vpW = 1000;
        this.vpH = 1000;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.inch = 0;
        this.records = new ArrayList(20);
    }

    protected boolean readRecords(DataInputStream dataInputStream) throws IOException {
        int n = 1;
        int n2 = 0;
        this.numRecords = 0;
        while (n > 0) {
            n2 = this.readInt(dataInputStream);
            n2 -= 3;
            n = this.readShort(dataInputStream);
            if (n <= 0) break;
            MetaRecord metaRecord = new MetaRecord();
            switch (n) {
                case 1583: {
                    for (int i = 0; i < n2; ++i) {
                        short s = this.readShort(dataInputStream);
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    int n3;
                    int n4;
                    short s = this.readShort(dataInputStream);
                    short s2 = this.readShort(dataInputStream);
                    int n5 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    int n7 = 4;
                    int n8 = 0;
                    int n9 = 0;
                    short s3 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    if ((n6 & 4) != 0) {
                        n9 = this.readShort(dataInputStream);
                        s3 = this.readShort(dataInputStream);
                        n10 = this.readShort(dataInputStream);
                        n11 = this.readShort(dataInputStream);
                        n7 += 4;
                        n8 = 1;
                    }
                    byte[] byArray = new byte[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        byArray[n4] = dataInputStream.readByte();
                    }
                    n7 += (n5 + 1) / 2;
                    if (n5 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    if (n7 < n2) {
                        for (n3 = n7; n3 < n2; ++n3) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.AddElement(new Integer(s2));
                    metaRecord.AddElement(new Integer(s));
                    metaRecord.AddElement(new Integer(n6));
                    if (n8 != 0) {
                        metaRecord.AddElement(new Integer(n9));
                        metaRecord.AddElement(new Integer(s3));
                        metaRecord.AddElement(new Integer(n10));
                        metaRecord.AddElement(new Integer(n11));
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 1313: {
                    int n8;
                    int n6;
                    int n12 = this.readShort(dataInputStream);
                    int n13 = 1;
                    byte[] byArray = new byte[n12];
                    for (n6 = 0; n6 < n12; ++n6) {
                        byArray[n6] = dataInputStream.readByte();
                    }
                    if (n12 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    n13 += (n12 + 1) / 2;
                    n6 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    if ((n13 += 2) < n2) {
                        for (n8 = n13; n8 < n2; ++n8) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(n6));
                    this.records.add(metaRecord);
                    break;
                }
                case 763: {
                    short s = this.readShort(dataInputStream);
                    short s4 = this.readShort(dataInputStream);
                    short s5 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    int n8 = dataInputStream.readByte();
                    int n9 = dataInputStream.readByte();
                    short s3 = dataInputStream.readByte();
                    int n10 = dataInputStream.readByte() & 0xFF;
                    int n11 = dataInputStream.readByte();
                    byte by = dataInputStream.readByte();
                    byte by2 = dataInputStream.readByte();
                    int n4 = dataInputStream.readByte();
                    int n3 = 2 * (n2 - 9);
                    byte[] byArray = new byte[n3];
                    for (int i = 0; i < n3; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    metaRecord = new MetaRecord.StringRecord(string);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.AddElement(new Integer(s));
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(n10));
                    metaRecord.AddElement(new Integer(n9));
                    metaRecord.AddElement(new Integer(s3));
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(s5));
                    this.records.add(metaRecord);
                    break;
                }
                case 259: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s));
                    this.records.add(metaRecord);
                    break;
                }
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    short s6 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s6));
                    metaRecord.AddElement(new Integer(s));
                    this.records.add(metaRecord);
                    if (!this._bext || n != 524) break;
                    this.vpW = s6;
                    this.vpH = s;
                    this._bext = false;
                    break;
                }
                case 527: 
                case 529: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    short s7 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s7));
                    metaRecord.AddElement(new Integer(s));
                    this.records.add(metaRecord);
                    break;
                }
                case 1040: 
                case 1042: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    short s8 = this.readShort(dataInputStream);
                    short s9 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s9));
                    metaRecord.AddElement(new Integer(s));
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(s8));
                    this.records.add(metaRecord);
                    this.scaleX = this.scaleX * (float)s9 / (float)n6;
                    this.scaleY = this.scaleY * (float)s / (float)s8;
                    break;
                }
                case 764: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    int n14 = this.readInt(dataInputStream);
                    int n15 = n14 & 0xFF;
                    int n16 = (n14 & 0xFF00) >> 8;
                    int n6 = (n14 & 0xFF0000) >> 16;
                    int n7 = (n14 & 0x3000000) >> 24;
                    metaRecord.AddElement(new Integer(n15));
                    metaRecord.AddElement(new Integer(n16));
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    this.records.add(metaRecord);
                    break;
                }
                case 762: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    Integer n17 = new Integer(this.readShort(dataInputStream));
                    metaRecord.AddElement(n17);
                    int n18 = this.readInt(dataInputStream);
                    int n19 = this.readInt(dataInputStream);
                    if (n2 == 6) {
                        this.readShort(dataInputStream);
                    }
                    int n6 = n19 & 0xFF;
                    int n7 = (n19 & 0xFF00) >> 8;
                    int n8 = (n19 & 0xFF0000) >> 16;
                    int n9 = (n19 & 0x3000000) >> 24;
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(n18));
                    this.records.add(metaRecord);
                    break;
                }
                case 302: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord.AddElement(new Integer(s));
                    this.records.add(metaRecord);
                    break;
                }
                case 513: 
                case 521: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n20 = this.readInt(dataInputStream);
                    int n21 = n20 & 0xFF;
                    int n22 = (n20 & 0xFF00) >> 8;
                    int n6 = (n20 & 0xFF0000) >> 16;
                    int n7 = (n20 & 0x3000000) >> 24;
                    metaRecord.AddElement(new Integer(n21));
                    metaRecord.AddElement(new Integer(n22));
                    metaRecord.AddElement(new Integer(n6));
                    this.records.add(metaRecord);
                    break;
                }
                case 531: 
                case 532: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    short s10 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s10));
                    metaRecord.AddElement(new Integer(s));
                    this.records.add(metaRecord);
                    break;
                }
                case 262: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord.AddElement(new Integer(s));
                    this.records.add(metaRecord);
                    break;
                }
                case 1336: {
                    int n8;
                    int n7;
                    int n6;
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n23 = this.readShort(dataInputStream);
                    int[] nArray = new int[n23];
                    int n24 = 0;
                    for (n6 = 0; n6 < n23; ++n6) {
                        nArray[n6] = this.readShort(dataInputStream);
                        n24 += nArray[n6];
                    }
                    metaRecord.AddElement(new Integer(n23));
                    for (n6 = 0; n6 < n23; ++n6) {
                        metaRecord.AddElement(new Integer(nArray[n6]));
                    }
                    n6 = n23 + 1;
                    for (n7 = 0; n7 < n23; ++n7) {
                        for (n8 = 0; n8 < nArray[n7]; ++n8) {
                            metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                            metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                        }
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 804: 
                case 805: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n25 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n25));
                    for (int i = 0; i < n25; ++i) {
                        metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                        metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    short s11 = this.readShort(dataInputStream);
                    short s12 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(s12));
                    metaRecord.AddElement(new Integer(s11));
                    metaRecord.AddElement(new Integer(s));
                    this.records.add(metaRecord);
                    break;
                }
                case 1791: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    short s13 = this.readShort(dataInputStream);
                    short s14 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s));
                    metaRecord.AddElement(new Integer(s13));
                    metaRecord.AddElement(new Integer(s14));
                    metaRecord.AddElement(new Integer(n6));
                    this.records.add(metaRecord);
                    break;
                }
                case 1564: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    short s15 = this.readShort(dataInputStream);
                    short s16 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(s16));
                    metaRecord.AddElement(new Integer(s15));
                    metaRecord.AddElement(new Integer(s));
                    this.records.add(metaRecord);
                    break;
                }
                case 2071: 
                case 2074: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    short s17 = this.readShort(dataInputStream);
                    short s18 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    short s3 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s3));
                    metaRecord.AddElement(new Integer(n9));
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(s18));
                    metaRecord.AddElement(new Integer(s17));
                    metaRecord.AddElement(new Integer(s));
                    this.records.add(metaRecord);
                    break;
                }
                case 1565: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n26 = this.readInt(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    short s19 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n26));
                    metaRecord.AddElement(new Integer(s));
                    metaRecord.AddElement(new Integer(s19));
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(n6));
                    this.records.add(metaRecord);
                    break;
                }
                case 258: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    short s = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s));
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 260: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n27 = n2 == 1 ? this.readShort(dataInputStream) : this.readInt(dataInputStream);
                    metaRecord.AddElement(new Integer(n27));
                    this.records.add(metaRecord);
                    break;
                }
                case 2881: {
                    int n28 = dataInputStream.readInt() & 0xFF;
                    short s = this.readShort(dataInputStream);
                    short s20 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    short s3 = this.readShort(dataInputStream);
                    int n10 = this.readShort(dataInputStream);
                    int n11 = 2 * n2 - 20;
                    byte[] byArray = new byte[n11];
                    for (int i = 0; i < n11; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.AddElement(new Integer(n28));
                    metaRecord.AddElement(new Integer(s));
                    metaRecord.AddElement(new Integer(s20));
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(n7));
                    metaRecord.AddElement(new Integer(n8));
                    metaRecord.AddElement(new Integer(n9));
                    metaRecord.AddElement(new Integer(s3));
                    metaRecord.AddElement(new Integer(n10));
                    this.records.add(metaRecord);
                    break;
                }
                case 322: {
                    int n6;
                    int n29 = dataInputStream.readInt() & 0xFF;
                    int n30 = 2 * n2 - 4;
                    byte[] byArray = new byte[n30];
                    for (n6 = 0; n6 < n30; ++n6) {
                        byArray[n6] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.AddElement(new Integer(n29));
                    this.records.add(metaRecord);
                    break;
                }
                default: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    for (int i = 0; i < n2; ++i) {
                        metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    }
                    this.records.add(metaRecord);
                }
            }
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public MetaRecord getRecord(int n) {
        return (MetaRecord)this.records.get(n);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public float getVpX() {
        return this.vpX;
    }

    public float getVpY() {
        return this.vpY;
    }

    public void setVpX(float f) {
        this.vpX = f;
    }

    public void setVpY(float f) {
        this.vpY = f;
    }
}

