/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.batik.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.batik.svggen.font.SVGFont;
import org.kabeja.svg.SVGUtils;

public class FontImport {
    String source;
    String destination;
    String fontDescriptionFile;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("The   source and/or destination directory and/or the fontdescription file are not set.");
            System.exit(0);
        }
        FontImport importer = new FontImport();
        importer.setSource(args[0]);
        importer.setDestination(args[1]);
        importer.setFontDescriptionFile(args[2]);
        importer.importFonts();
    }

    public void importFonts() {
        File[] files;
        File in = new File(this.source);
        File dest = new File(this.destination);
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if ((files = in.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".ttf");
            }
        })).length > 0) {
            try {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.fontDescriptionFile, true)));
                for (int i = 0; i < files.length; ++i) {
                    String fontFile = files[i].getName().toLowerCase();
                    fontFile = fontFile.substring(0, fontFile.indexOf(".ttf"));
                    File svgFont = new File(dest.getAbsolutePath() + File.separator + fontFile + ".svg");
                    this.importFont(files[i], svgFont, out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getFontDescriptionFile() {
        return this.fontDescriptionFile;
    }

    public void setFontDescriptionFile(String fontDescriptionFile) {
        this.fontDescriptionFile = fontDescriptionFile;
    }

    private void importFont(File source, File dest, BufferedWriter out) throws IOException {
        String shx = source.getName().toLowerCase();
        shx = shx.substring(0, shx.indexOf(".ttf"));
        shx = this.fixFileName(shx);
        String[] args = new String[]{source.getAbsolutePath(), "-id", shx, "-o", dest.getAbsolutePath()};
        SVGFont.main((String[])args);
        String uri = SVGUtils.fileToURI(dest);
        System.out.println("Imported:" + source.getName() + " to:" + uri);
        out.write(shx + " = " + uri + "\n");
    }

    private String fixFileName(String name) {
        StringBuffer buf = new StringBuffer();
        char[] c = name.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '_') continue;
            buf.append(c[i]);
        }
        return buf.toString();
    }
}

