/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.action;

import de.miethxml.toolkit.ui.UIUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.kabeja.svg.action.Messages;
import org.kabeja.svg.action.SVGDocumentAction;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class PrintAction
extends AbstractAction
implements SVGDocumentAction {
    SVGDocument doc;

    public PrintAction() {
        super.putValue("SmallIcon", new ImageIcon(UIUtils.resourceToBytes(this.getClass(), (String)"/icons/print.gif")));
        super.putValue("ShortDescription", Messages.getString("editor.action.print"));
    }

    public void setDocument(SVGDocument doc) {
        this.doc = doc;
    }

    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PrintAction.this.print();
            }
        });
    }

    protected void print() {
        PrintTranscoder pt = new PrintTranscoder();
        pt.addTranscodingHint(PrintTranscoder.KEY_SHOW_PAGE_DIALOG, (Object)Boolean.TRUE);
        pt.addTranscodingHint(PrintTranscoder.KEY_SHOW_PRINTER_DIALOG, (Object)Boolean.TRUE);
        try {
            pt.transcode(new TranscoderInput((Document)this.doc), null);
            pt.print();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

