/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.svg.action.CanvasUpdateManager;
import org.kabeja.svg.action.CanvasUpdateRunnable;
import org.kabeja.svg.action.CustomActionView;
import org.kabeja.svg.action.DXFDocumentAction;
import org.kabeja.svg.action.GroupAction;
import org.kabeja.svg.action.GroupActionUnSelector;
import org.kabeja.svg.action.JSVGCanvasAction;
import org.kabeja.svg.action.SVGDocumentAction;
import org.kabeja.svg.action.ViewerAction;
import org.kabeja.svg.tools.DXFSAXDocumentFactory;
import org.kabeja.ui.DXFDocumentViewComponent;
import org.kabeja.ui.JToggleButtonGroup;
import org.kabeja.ui.PropertiesEditor;
import org.kabeja.ui.PropertiesListener;
import org.kabeja.ui.ServiceManager;
import org.kabeja.ui.Serviceable;
import org.kabeja.ui.UIException;
import org.kabeja.ui.event.DXFDocumentChangeEventProvider;
import org.kabeja.ui.event.DXFDocumentChangeListener;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGMatrix;

public class SVGViewUIComponent
implements DXFDocumentViewComponent,
Serviceable,
DXFDocumentChangeListener,
CanvasUpdateManager,
PropertiesListener {
    protected boolean initialized = false;
    protected JSVGCanvas canvas;
    protected String title = "SVGView";
    protected JLabel infoLabel;
    protected JPanel parentPanel;
    protected JPanel panel;
    protected CardLayout cards;
    protected List actions = new ArrayList();
    String[] data = new String[]{"Modelspace-Calculated", "Modelspace", "Paperspace Calculated", "Paperspace", "Mixed"};
    protected DXFDocument doc;
    protected JComboBox switchViewBox;
    protected JToolBar toolbar;
    protected Map properties = new HashMap();
    protected JLabel mousePosition;
    private DecimalFormat format;

    public String getTitle() {
        return this.title;
    }

    public JComponent getView() {
        if (!this.initialized) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            this.format = new DecimalFormat("###.#####", symbols);
            this.cards = new CardLayout();
            this.parentPanel = new JPanel(new BorderLayout());
            this.panel = new JPanel(this.cards){

                public void setEnabled(boolean b) {
                    if (!b) {
                        SVGViewUIComponent.this.canvas.setSVGDocument(null);
                    }
                }
            };
            this.parentPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.infoLabel = new JLabel("DXF2SVGViewer", 0){
                private static final long serialVersionUID = 1L;

                protected void paintComponent(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    super.paintComponent(g);
                }
            };
            this.infoLabel.setOpaque(true);
            this.infoLabel.setBackground(new Color(96, 96, 96));
            this.infoLabel.setForeground(Color.WHITE);
            this.infoLabel.setFont(new Font("SansSerif", 1, 28));
            this.panel.add((Component)this.infoLabel, "info");
            this.mousePosition = new JLabel("SVG x: y:");
            this.mousePosition.setBorder(BorderFactory.createLoweredBevelBorder());
            this.parentPanel.add((Component)this.mousePosition, "South");
            this.toolbar = new JToolBar();
            this.parentPanel.add((Component)this.toolbar, "North");
            this.canvas = new JSVGCanvas();
            this.canvas.setDoubleBuffered(true);
            this.canvas.setDoubleBufferedRendering(true);
            this.canvas.setDocumentState(1);
            this.canvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

                public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                    SVGViewUIComponent.this.infoLabel.setText("Loading ...");
                }

                public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                    SVGViewUIComponent.this.infoLabel.setText("Draft loaded");
                }
            });
            this.canvas.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

                public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                    SVGViewUIComponent.this.infoLabel.setText("Building draft ...");
                }

                public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                    SVGViewUIComponent.this.infoLabel.setText("Finished building");
                }
            });
            this.canvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

                public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                    SVGViewUIComponent.this.infoLabel.setText("Rendering draft ...");
                }

                public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                    SVGViewUIComponent.this.infoLabel.setText("");
                    SVGViewUIComponent.this.cards.show(SVGViewUIComponent.this.panel, "view");
                }
            });
            this.canvas.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){
                private int count = 3;

                public void mouseMoved(MouseEvent e) {
                    if (this.count == 3) {
                        this.count = 0;
                        Point p = e.getPoint();
                        SVGMatrix matrix = SVGViewUIComponent.this.canvas.getSVGDocument().getRootElement().getScreenCTM().inverse();
                        double x = (double)matrix.getA() * p.getX() + (double)matrix.getC() * p.getY() + (double)matrix.getE();
                        double y = (double)matrix.getB() * p.getX() + (double)matrix.getD() * p.getY() + (double)matrix.getF();
                        SVGViewUIComponent.this.mousePosition.setText("SVG  x:" + SVGViewUIComponent.this.format.format(x) + "  y:" + SVGViewUIComponent.this.format.format(y) + "   DXF x:" + SVGViewUIComponent.this.format.format(x) + "  y:" + SVGViewUIComponent.this.format.format(-1.0 * y));
                    } else {
                        ++this.count;
                    }
                }
            });
            this.panel.add((Component)this.canvas, "view");
            this.parentPanel.add((Component)this.panel, "Center");
            this.registerActions();
            this.initialized = true;
        }
        return this.parentPanel;
    }

    public void showDXFDocument(DXFDocument doc) throws UIException {
        this.doc = doc;
        this.properties.clear();
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof DXFDocumentAction)) continue;
            ((DXFDocumentAction)obj).setDXFDocument(doc);
        }
        this.updateView(doc);
    }

    protected void updateView(DXFDocument doc) throws UIException {
        try {
            this.infoLabel.setText("Starting ...");
            this.infoLabel.repaint();
            this.cards.show(this.panel, "info");
            DXFSAXDocumentFactory factory = new DXFSAXDocumentFactory();
            SVGDocument svgDoc = factory.createDocument(doc, this.properties);
            this.setSVGDocument(svgDoc);
        }
        catch (Exception e) {
            this.infoLabel.setText("Error:" + e.getMessage());
            this.infoLabel.repaint();
            this.cards.show(this.panel, "info");
            throw new UIException(e);
        }
    }

    public void setServiceManager(ServiceManager manager) {
        int i;
        org.kabeja.ui.Component[] obj = manager.getServiceComponents(DXFDocumentChangeEventProvider.SERVICE);
        for (i = 0; i < obj.length; ++i) {
            ((DXFDocumentChangeEventProvider)obj[i]).addDXFDocumentChangeListener((DXFDocumentChangeListener)this);
        }
        obj = manager.getServiceComponents(ViewerAction.SERVICE);
        for (i = 0; i < obj.length; ++i) {
            this.addAction((ViewerAction)obj[i]);
        }
        this.registerActions();
    }

    public void changed(DXFDocument doc) {
        try {
            this.updateView(doc);
        }
        catch (UIException e) {
            e.printStackTrace();
        }
    }

    public void invokeAndWait(Runnable r) throws InterruptedException {
        this.canvas.getUpdateManager().getUpdateRunnableQueue().invokeAndWait(r);
    }

    public void invokeLater(Runnable r) throws InterruptedException {
        this.canvas.getUpdateManager().getUpdateRunnableQueue().invokeLater(r);
    }

    protected void registerActions() {
        this.toolbar.removeAll();
        Iterator i = this.actions.iterator();
        JToggleButtonGroup group = new JToggleButtonGroup();
        while (i.hasNext()) {
            ViewerAction action = (ViewerAction)i.next();
            if (action instanceof CustomActionView) {
                this.toolbar.add(((CustomActionView)((Object)action)).getView());
            } else if (action instanceof Action) {
                if (action instanceof ItemListener) {
                    JToggleButton button = new JToggleButton((Action)((Object)action));
                    if (action instanceof GroupAction) {
                        group.add(button);
                    } else if (action instanceof GroupActionUnSelector) {
                        group.addUnSelector(button);
                    }
                    button.setText("");
                    button.addItemListener((ItemListener)((Object)action));
                    this.toolbar.add(button);
                } else {
                    this.toolbar.add((Action)((Object)action));
                }
            }
            if (action instanceof PropertiesEditor) {
                PropertiesEditor editor = (PropertiesEditor)action;
                editor.addPropertiesListener((PropertiesListener)this);
                editor.setProperties(this.properties);
            }
            if (action instanceof CanvasUpdateRunnable) {
                ((CanvasUpdateRunnable)((Object)action)).setCanvasUpdateManager(this);
            }
            if (action instanceof Interactor) {
                this.canvas.getInteractors().add((Interactor)action);
            }
            if (action instanceof JSVGCanvasAction) {
                ((JSVGCanvasAction)action).setJSVGCanvas(this.canvas);
            }
            if (this.doc == null || !(action instanceof DXFDocumentAction)) continue;
            ((DXFDocumentAction)action).setDXFDocument(this.doc);
        }
    }

    protected void setSVGDocument(SVGDocument doc) {
        this.canvas.setSVGDocument(doc);
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            ViewerAction action = (ViewerAction)i.next();
            if (!(action instanceof SVGDocumentAction)) continue;
            ((SVGDocumentAction)action).setDocument(doc);
        }
    }

    public void addAction(ViewerAction action) {
        this.actions.add(action);
    }

    public void propertiesChanged(Map properties) {
        if (properties.containsKey("bounds-rule") && this.doc != null) {
            this.properties.put("bounds-rule", properties.get("bounds-rule"));
            try {
                this.updateView(this.doc);
            }
            catch (UIException e) {
                e.printStackTrace();
            }
        }
    }
}

