/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.viewer;

import de.miethxml.toolkit.ui.SmallShadowBorder;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SVGViewer {
    private JFrame frame;
    private JTextField uriField;
    private JSVGCanvas svgCanvas;
    private JFileChooser fc;
    private JLabel infoLabel;
    private CardLayout cards;
    private JPanel parentPanel;
    private SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory("org.kabeja.svg.DXF2SVGReader", true);
    private double scaleXY = 1.0;

    public void initialize() {
        this.frame = new JFrame("SVGViewer");
        this.frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel(new FlowLayout(0, 8, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        panel.add(new JLabel("Url:"));
        this.uriField = new JTextField(30);
        this.uriField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runnable r = new Runnable(){

                    public void run() {
                        SVGViewer.this.load(new File(SVGViewer.this.uriField.getText()));
                    }
                };
                Thread t = new Thread(r);
                t.start();
            }
        });
        panel.add(this.uriField);
        this.fc = new JFileChooser();
        JButton button = new JButton("Open");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int value = SVGViewer.this.fc.showOpenDialog(SVGViewer.this.frame);
                if (value == 0) {
                    SVGViewer.this.svgCanvas.setSVGDocument(null);
                    Runnable r = new Runnable(){

                        public void run() {
                            SVGViewer.this.infoLabel.setText("Starting ......");
                            SVGViewer.this.cards.show(SVGViewer.this.parentPanel, "info");
                            File file = SVGViewer.this.fc.getSelectedFile();
                            SVGViewer.this.uriField.setText(file.getAbsolutePath());
                            SVGViewer.this.load(file);
                        }
                    };
                    Thread t = new Thread(r);
                    t.start();
                }
            }
        });
        panel.add(button);
        button = new JButton("Zoom in");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AffineTransform at = new AffineTransform();
                        SVGViewer.this.scaleXY += 0.3;
                        at.setToScale(SVGViewer.this.scaleXY, SVGViewer.this.scaleXY);
                        SVGViewer.this.svgCanvas.setRenderingTransform(at);
                    }
                });
            }
        });
        panel.add(button);
        button = new JButton("Zoom out");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AffineTransform at = new AffineTransform();
                        SVGViewer.this.scaleXY -= 0.3;
                        at.setToScale(SVGViewer.this.scaleXY, SVGViewer.this.scaleXY);
                        SVGViewer.this.svgCanvas.setRenderingTransform(at);
                    }
                });
            }
        });
        panel.add(button);
        button = new JButton("Export JPEG");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int value = SVGViewer.this.fc.showSaveDialog(SVGViewer.this.frame);
                if (value == 0) {
                    Runnable r = new Runnable(){

                        public void run() {
                            File file = SVGViewer.this.fc.getSelectedFile();
                            try {
                                SVGViewer.this.saveToJPEG(new FileOutputStream(file));
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    Thread t = new Thread(r);
                    t.start();
                }
            }
        });
        panel.add(button);
        this.frame.getContentPane().add((Component)panel, "North");
        this.cards = new CardLayout();
        this.parentPanel = new JPanel(this.cards);
        this.svgCanvas = new JSVGCanvas();
        this.svgCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                SVGViewer.this.infoLabel.setText("Loading Draft...");
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                SVGViewer.this.infoLabel.setText("Draft Loaded.");
            }
        });
        this.svgCanvas.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                SVGViewer.this.infoLabel.setText("Building...");
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                SVGViewer.this.infoLabel.setText("Build Done.");
            }
        });
        this.svgCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                SVGViewer.this.infoLabel.setText("Rendering Draft...");
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                SVGViewer.this.infoLabel.setText("");
                SVGViewer.this.cards.show(SVGViewer.this.parentPanel, "view");
            }
        });
        JSVGScrollPane sp = new JSVGScrollPane(this.svgCanvas);
        sp.setBorder((Border)new SmallShadowBorder());
        this.parentPanel.add((Component)sp, "view");
        this.parentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.infoLabel = new JLabel("DXF2SVGViewer", 0);
        this.parentPanel.add((Component)this.infoLabel, "info");
        this.parentPanel.setPreferredSize(new Dimension(640, 480));
        this.frame.getContentPane().add((Component)this.parentPanel, "Center");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void load(File file) {
        if (file.exists()) {
            this.load(file.toURI().toASCIIString());
        } else {
            System.out.println("no file:" + file);
        }
    }

    public void load(String uri) {
        try {
            System.gc();
            SAXSVGDocumentFactory f = null;
            f = uri.toLowerCase().endsWith(".dxf") ? this.factory : new SAXSVGDocumentFactory(null);
            SVGDocument doc = f.createSVGDocument(uri);
            this.svgCanvas.setDocumentState(1);
            this.svgCanvas.setSVGDocument(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
            this.infoLabel.setText("Error:" + e.getLocalizedMessage());
        }
        catch (Error e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
            this.infoLabel.setText("Error:" + e.getLocalizedMessage());
        }
    }

    public void saveToJPEG(OutputStream out) {
        JPEGTranscoder trans = new JPEGTranscoder();
        try {
            trans.transcode(new TranscoderInput((Document)this.svgCanvas.getSVGDocument()), new TranscoderOutput(out));
        }
        catch (TranscoderException e) {
            e.printStackTrace();
        }
    }
}

