/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.xslt;

import java.io.FileReader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.kabeja.xml.AbstractSAXFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXXSLTFilter
extends AbstractSAXFilter {
    public static final String PROPERTY_XSLTSTYLESHEET = "stylesheet";
    protected ContentHandler handler;
    protected String xsltSource;

    public void startDocument() throws SAXException {
        if (this.properties.containsKey(PROPERTY_XSLTSTYLESHEET)) {
            try {
                SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                FileReader fileReader = new FileReader((String)this.properties.get(PROPERTY_XSLTSTYLESHEET));
                SAXSource sAXSource = new SAXSource(new InputSource(fileReader));
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler(sAXSource);
                this.setParameters(transformerHandler);
                transformerHandler.setResult(new SAXResult(this.handler));
                super.setContentHandler((ContentHandler)transformerHandler);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
        super.startDocument();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
        super.setContentHandler(contentHandler);
    }

    protected void setParameters(TransformerHandler transformerHandler) {
        Transformer transformer = transformerHandler.getTransformer();
        Iterator iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (PROPERTY_XSLTSTYLESHEET.equals(iterator)) continue;
            transformer.setParameter(string, this.properties.get(string));
        }
    }

    public Map getProperties() {
        return this.properties;
    }
}

