/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing.scripting.impl;

import de.miethxml.toolkit.ui.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;
import org.kabeja.processing.scripting.impl.Global;
import org.kabeja.ui.DXFDocumentViewComponent;
import org.kabeja.ui.UIException;
import org.kabeja.ui.event.DXFDocumentChangeEventProvider;
import org.kabeja.ui.event.DXFDocumentChangeListener;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptShell
extends AbstractPostProcessor
implements DXFDocumentViewComponent,
DXFDocumentChangeEventProvider {
    protected static final String COMMAND_PREFIX = "js>";
    protected JFrame frame;
    protected JTextArea textArea;
    protected HashMap actions = new HashMap();
    protected ArrayList history = new ArrayList();
    protected int historyPos = 0;
    protected ScriptWorker worker;
    protected String title = "JSShell";
    protected ArrayList listeners = new ArrayList();
    protected DXFDocument doc;
    static /* synthetic */ Class class$org$kabeja$processing$scripting$impl$Global;

    public void process(DXFDocument doc, Map context) throws ProcessorException {
        this.worker = new ScriptWorker(doc);
        this.worker.start();
        this.init();
        while (this.worker.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setProperties(Map properties) {
    }

    protected void init() {
        this.frame = new JFrame(this.getTitle());
        this.frame.setJMenuBar(this.createMenuBar());
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JavaScriptShell.this.dispose();
            }
        });
        this.frame.getContentPane().add((Component)this.getView(), "Center");
        JPanel p = new JPanel(new FlowLayout(2, 2, 2));
        JButton button = new JButton((Action)this.actions.get("close"));
        p.add(button);
        this.frame.getContentPane().add((Component)p, "South");
        this.frame.setSize(new Dimension(640, 480));
        this.frame.setVisible(true);
        this.newShellLine();
    }

    protected JToolBar createToolbar() {
        JToolBar toolbar = new JToolBar();
        JButton button = new JButton((Action)this.actions.get("copy"));
        button.setToolTipText(button.getText());
        button.setText("");
        toolbar.add(button);
        button = new JButton((Action)this.actions.get("paste"));
        button.setToolTipText(button.getText());
        button.setText("");
        toolbar.add(button);
        button = new JButton((Action)this.actions.get("cut"));
        button.setToolTipText(button.getText());
        button.setText("");
        toolbar.add(button);
        button = new JButton((Action)this.actions.get("reload"));
        button.setToolTipText(button.getText());
        button.setText("");
        toolbar.add(button);
        return toolbar;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem((Action)this.actions.get("open"));
        item.setToolTipText(item.getText());
        menu.add(item);
        item = new JMenuItem((Action)this.actions.get("save"));
        menu.add(item);
        menu.add(new JSeparator());
        item = new JMenuItem((Action)this.actions.get("close"));
        menu.add(item);
        menubar.add(menu);
        return menubar;
    }

    protected void initActions() {
        AbstractAction action = new AbstractAction("Cut", new ImageIcon(UIUtils.resourceToBytes(((Object)((Object)this)).getClass(), (String)"/icons/cut_edit.gif"))){

            public void actionPerformed(ActionEvent e) {
                JavaScriptShell.this.textArea.cut();
            }
        };
        this.actions.put("cut", action);
        action = new AbstractAction("Paste", new ImageIcon(UIUtils.resourceToBytes(((Object)((Object)this)).getClass(), (String)"/icons/paste_edit.gif"))){

            public void actionPerformed(ActionEvent e) {
                JavaScriptShell.this.textArea.paste();
            }
        };
        this.actions.put("paste", action);
        action = new AbstractAction("Copy", new ImageIcon(UIUtils.resourceToBytes(((Object)((Object)this)).getClass(), (String)"/icons/copy_edit.gif"))){

            public void actionPerformed(ActionEvent e) {
                JavaScriptShell.this.textArea.copy();
            }
        };
        this.actions.put("copy", action);
        action = new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                JavaScriptShell.this.dispose();
            }
        };
        this.actions.put("close", action);
        action = new AbstractAction("Save"){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fs = new JFileChooser();
                int r = fs.showSaveDialog(JavaScriptShell.this.frame);
                if (r == 0) {
                    try {
                        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fs.getSelectedFile())));
                        Iterator i = JavaScriptShell.this.history.iterator();
                        while (i.hasNext()) {
                            out.write((String)i.next());
                            out.newLine();
                        }
                        out.flush();
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.actions.put("save", action);
        action = new AbstractAction("Open"){

            public void actionPerformed(ActionEvent e) {
                JavaScriptShell.this.textArea.setText(JavaScriptShell.COMMAND_PREFIX);
                JavaScriptShell.this.history.clear();
                JFileChooser fs = new JFileChooser();
                int r = fs.showOpenDialog(JavaScriptShell.this.frame);
                if (r == 0) {
                    try {
                        String line;
                        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fs.getSelectedFile())));
                        while ((line = in.readLine()) != null) {
                            JavaScriptShell.this.textArea.append(line);
                            JavaScriptShell.this.evalString(JavaScriptShell.COMMAND_PREFIX + line);
                        }
                        in.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.actions.put("open", action);
        action = new AbstractAction("Update views", new ImageIcon(UIUtils.resourceToBytes(((Object)((Object)this)).getClass(), (String)"/icons/reload.gif"))){

            public void actionPerformed(ActionEvent e) {
                JavaScriptShell.this.fireDXFDocumentChangeEvent();
            }
        };
        this.actions.put("reload", action);
    }

    protected String getLineAtCaretPosition() {
        try {
            int lineNumber = this.textArea.getLineOfOffset(this.textArea.getCaretPosition());
            int startOffset = this.textArea.getLineStartOffset(lineNumber);
            int length = this.textArea.getCaretPosition() - startOffset;
            String line = this.textArea.getText(startOffset, length);
            return line;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected int getStartOffsetAtCaretPosition() {
        try {
            int lineNumber = this.textArea.getLineOfOffset(this.textArea.getCaretPosition());
            int startOffset = this.textArea.getLineStartOffset(lineNumber);
            return startOffset;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected void evalString(String line) {
        this.textArea.append("\n");
        if (line.startsWith(COMMAND_PREFIX)) {
            String script = line.substring(COMMAND_PREFIX.length());
            this.history.add(script);
            this.worker.executeScript(script);
        } else {
            this.newShellLine();
        }
    }

    protected void newShellLine() {
        this.textArea.append(COMMAND_PREFIX);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    protected void write(String str) {
        try {
            this.textArea.getDocument().insertString(this.textArea.getCaretPosition(), str, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void dispose() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.worker.dispose();
    }

    public void showDXFDocument(DXFDocument doc) throws UIException {
        this.doc = doc;
        this.worker = new ScriptWorker(doc);
        this.worker.start();
    }

    public String getTitle() {
        return this.title;
    }

    public JComponent getView() {
        this.textArea = new JTextArea();
        this.textArea.addKeyListener(new CommandKeyListener());
        this.initActions();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.textArea), "Center");
        panel.add((Component)this.createToolbar(), "North");
        panel.setPreferredSize(new Dimension(640, 480));
        this.newShellLine();
        this.worker = new ScriptWorker(null);
        this.worker.start();
        return panel;
    }

    public void addDXFDocumentChangeListener(DXFDocumentChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeDXFDocumentChangeListener(DXFDocumentChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDXFDocumentChangeEvent() {
        if (this.doc != null) {
            Iterator i = ((ArrayList)this.listeners.clone()).iterator();
            while (i.hasNext()) {
                DXFDocumentChangeListener l = (DXFDocumentChangeListener)i.next();
                l.changed(this.doc);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class JTextAreaPrintWriter
    extends OutputStream {
        StringBuffer buf = new StringBuffer();

        protected JTextAreaPrintWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            if (b == 13) {
                return;
            }
            if (b == 10) {
                JTextArea jTextArea = JavaScriptShell.this.textArea;
                synchronized (jTextArea) {
                    JavaScriptShell.this.textArea.append(this.buf.toString() + "\n");
                }
                this.buf.setLength(0);
            } else {
                this.buf.append((char)b);
            }
        }
    }

    protected class ScriptWorker
    extends Thread {
        protected Context ctx;
        protected Scriptable scope;
        protected boolean execute = false;
        protected boolean dispose = false;
        protected String script;
        protected DXFDocument doc;
        PrintStream err;
        PrintStream out;
        protected PrintStream output = new PrintStream(new JTextAreaPrintWriter());

        public ScriptWorker(DXFDocument doc) {
            this.doc = doc;
        }

        protected void init() {
            ContextFactory f = new ContextFactory();
            this.ctx = f.enter();
            this.err = System.err;
            this.out = System.out;
            this.scope = this.ctx.initStandardObjects(null, false);
            try {
                ScriptableObject.defineClass((Scriptable)this.scope, (Class)(class$org$kabeja$processing$scripting$impl$Global == null ? (class$org$kabeja$processing$scripting$impl$Global = JavaScriptShell.class$("org.kabeja.processing.scripting.impl.Global")) : class$org$kabeja$processing$scripting$impl$Global));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.scope = new Global();
            Global.setOutput(this.output);
            this.ctx.setErrorReporter(new ErrorReporter(){

                public void error(String arg0, String arg1, int arg2, String arg3, int arg4) {
                    ((ScriptWorker)ScriptWorker.this).JavaScriptShell.this.textArea.append(arg0 + " from line:" + arg3 + "\n");
                }

                public EvaluatorException runtimeError(String arg0, String arg1, int arg2, String arg3, int arg4) {
                    ((ScriptWorker)ScriptWorker.this).JavaScriptShell.this.textArea.append(arg0 + " from line:" + arg3 + "\n");
                    return new EvaluatorException(arg0);
                }

                public void warning(String arg0, String arg1, int arg2, String arg3, int arg4) {
                    ((ScriptWorker)ScriptWorker.this).JavaScriptShell.this.textArea.append(arg0 + " from line:" + arg3 + "\n");
                }
            });
            Object jsOut = Context.javaToJS((Object)this.doc, (Scriptable)this.scope);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"dxf", (Object)jsOut);
            JavaScriptShell.this.textArea.setText("");
            if (this.doc != null) {
                JavaScriptShell.this.textArea.append("DXFDocument available as 'dxf'\n");
            }
            JavaScriptShell.this.newShellLine();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.init();
            while (!this.dispose) {
                if (this.execute) {
                    block9: {
                        try {
                            Object result = this.ctx.evaluateString(this.scope, this.script, "<cmd>", 1, null);
                            String r = Context.toString((Object)result);
                            if (r.equals("undefined")) break block9;
                            JTextArea jTextArea = JavaScriptShell.this.textArea;
                            synchronized (jTextArea) {
                                JavaScriptShell.this.textArea.append(r);
                                JavaScriptShell.this.textArea.append("\n");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(this.output);
                            this.init();
                        }
                    }
                    this.execute = false;
                    JavaScriptShell.this.newShellLine();
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Context.exit();
        }

        public void executeScript(String str) {
            this.script = str;
            this.execute = true;
            while (this.execute) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void dispose() {
            System.setErr(this.err);
            System.setOut(this.out);
            this.dispose = true;
        }
    }

    public class CommandKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                JavaScriptShell.this.evalString(JavaScriptShell.this.getLineAtCaretPosition());
                e.consume();
                JavaScriptShell.this.historyPos = JavaScriptShell.this.history.size() - 1;
            } else if (e.getKeyCode() == 8 || e.getKeyCode() == 37) {
                try {
                    int lineNumber = JavaScriptShell.this.textArea.getLineOfOffset(JavaScriptShell.this.textArea.getCaretPosition());
                    int startOffset = JavaScriptShell.this.textArea.getLineStartOffset(lineNumber);
                    int l = JavaScriptShell.this.textArea.getCaretPosition() - startOffset;
                    if (l <= JavaScriptShell.COMMAND_PREFIX.length()) {
                        e.consume();
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            } else if (e.getKeyCode() == 38) {
                if (JavaScriptShell.this.historyPos >= 0 && JavaScriptShell.this.history.size() > 0) {
                    if (JavaScriptShell.this.historyPos >= JavaScriptShell.this.history.size() && JavaScriptShell.this.history.size() > 1) {
                        JavaScriptShell.this.historyPos = JavaScriptShell.this.history.size() - 2;
                    }
                    int start = JavaScriptShell.this.getStartOffsetAtCaretPosition() + JavaScriptShell.COMMAND_PREFIX.length();
                    JavaScriptShell.this.textArea.replaceRange((String)JavaScriptShell.this.history.get(JavaScriptShell.this.historyPos), start, JavaScriptShell.this.textArea.getDocument().getLength());
                    --JavaScriptShell.this.historyPos;
                }
                e.consume();
            } else if (e.getKeyCode() == 40) {
                if (JavaScriptShell.this.historyPos < JavaScriptShell.this.history.size() && JavaScriptShell.this.history.size() > 0) {
                    if (JavaScriptShell.this.historyPos < 0 && JavaScriptShell.this.history.size() > 1) {
                        JavaScriptShell.this.historyPos = 1;
                    }
                    int start = JavaScriptShell.this.getStartOffsetAtCaretPosition() + JavaScriptShell.COMMAND_PREFIX.length();
                    JavaScriptShell.this.textArea.replaceRange((String)JavaScriptShell.this.history.get(JavaScriptShell.this.historyPos), start, JavaScriptShell.this.textArea.getDocument().getLength());
                    ++JavaScriptShell.this.historyPos;
                }
                e.consume();
            }
        }
    }
}

