/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg;

import java.util.Map;
import org.kabeja.svg.SVGUtils;
import org.kabeja.xml.AbstractSAXFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FixedStrokeWidthFilter
extends AbstractSAXFilter {
    public static final String PROPERTY_FIXED_FONTSIZE = "fixed-fontsize";
    public static final String PERCENT = "%";
    protected int strokeWidth = 1;
    protected double strokeBase = 0.0;
    protected boolean replace = true;
    protected boolean fixFontsize = true;

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String strokeWidth;
        AttributesImpl attsImpl = new AttributesImpl(atts);
        if ("svg".equals(localName)) {
            String viewBox = atts.getValue("viewBox");
            this.parseViewBox(viewBox);
        } else if (localName.equals("defs")) {
            this.replace = false;
        } else if (this.replace && (strokeWidth = atts.getValue("stroke-width")) != null && strokeWidth.length() > 0) {
            attsImpl.setValue(attsImpl.getIndex("stroke-width"), this.createStrokeWidth(strokeWidth));
        }
        if ("text".equals(localName) && this.fixFontsize) {
            int index = -1;
            index = atts.getIndex("font-size");
            if (index != -1) {
                String fontSize = atts.getValue(index);
                attsImpl.setValue(index, "1px");
                double fixedSize = Double.parseDouble(fontSize) / 5.0;
                String scaleValue = " scale(" + SVGUtils.formatNumberAttribute(fixedSize) + ") ";
                index = -1;
                index = atts.getIndex("transform");
                if (index != -1) {
                    String transform = atts.getValue(index);
                    attsImpl.setValue(attsImpl.getIndex("transform"), transform + scaleValue);
                } else {
                    attsImpl.addAttribute("", "transform", "transform", SVGUtils.DEFAUL_ATTRIBUTE_TYPE, scaleValue);
                }
                double x = Double.parseDouble(atts.getValue("x")) / fixedSize;
                attsImpl.setValue(atts.getIndex("x"), "" + x);
                double y = Double.parseDouble(atts.getValue("y")) / fixedSize;
                attsImpl.setValue(atts.getIndex("y"), "" + y);
            }
        }
        super.startElement(uri, localName, qName, (Attributes)attsImpl);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("defs")) {
            this.replace = true;
        }
        super.endElement(uri, localName, qName);
    }

    protected void parseViewBox(String viewBox) {
        String[] data = viewBox.split("(\\s+)");
        if (data.length == 4) {
            double width = Math.abs(Double.parseDouble(data[2]));
            double height = Math.abs(Double.parseDouble(data[3]));
            this.strokeBase = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
        }
    }

    public String createStrokeWidth(String strokeWidth) {
        String value = strokeWidth.trim();
        if (value.endsWith(PERCENT)) {
            double f = Double.parseDouble(strokeWidth.substring(0, value.length() - 1)) / 100.0;
            return "" + f * this.strokeBase;
        }
        return strokeWidth;
    }

    public void setProperties(Map properties) {
        super.setProperties(properties);
        if (this.properties.containsKey(PROPERTY_FIXED_FONTSIZE)) {
            this.fixFontsize = Boolean.valueOf((String)this.properties.get(PROPERTY_FIXED_FONTSIZE));
        }
    }
}

